% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fs_surface.R
\name{write.fs.surface.ply2}
\alias{write.fs.surface.ply2}
\title{Write mesh to file in PLY2 File Format (.ply2)}
\usage{
write.fs.surface.ply2(filepath, vertex_coords, faces)
}
\arguments{
\item{filepath}{string. Full path to the output surface file, should end with '.off', but that is not enforced.}

\item{vertex_coords}{n x 3 matrix of doubles. Each row defined the x,y,z coords for a vertex.}

\item{faces}{n x 3 matrix of integers. Each row defined the 3 vertex indices that make up the face. WARNING: Vertex indices should be given in R-style, i.e., the index of the first vertex is 1. However, they will be written in FreeSurfer style, i.e., all indices will have 1 substracted, so that the index of the first vertex will be zero.}
}
\value{
string the format that was written. One of "tris" or "quads". Currently only triangular meshes are supported, so always 'tris'.
}
\description{
The PLY2 file format is a simply ASCII format for storing meshes. It is very similar to OFF and by far not as flexible as PLY.
}
\examples{
\donttest{
    # Read a surface from a file:
    surface_file = system.file("extdata", "lh.tinysurface",
     package = "freesurferformats", mustWork = TRUE);
    mesh = read.fs.surface(surface_file);

    # Now save it:
    write.fs.surface.ply2(tempfile(fileext=".ply2"), mesh$vertices, mesh$faces);
}

}
\seealso{
Other mesh export functions: 
\code{\link{write.fs.surface.obj}()},
\code{\link{write.fs.surface.off.ply2}()},
\code{\link{write.fs.surface.off}()},
\code{\link{write.fs.surface.ply}()},
\code{\link{write.fs.surface}()}
}
\concept{mesh export functions}
