% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freesurfer_read3.R
\name{freesurfer_read_curv}
\alias{freesurfer_read_curv}
\title{Read Freesufer Curv file}
\usage{
freesurfer_read_curv(file)
}
\arguments{
\item{file}{file name of a curvature file}
}
\value{
Numeric vector
}
\description{
Reads a Freesurfer curvature file according to the 
FREESURFER_HOME/matlab/read_curv.m file.
}
\examples{
if (have_fs()) {
   bert_dir = file.path(fs_subj_dir(), "bert", "surf")
   file = file.path(bert_dir, "lh.thickness")
   fid = file(file, open = "rb")
   out = freesurfer_read_curv(file)
} 
}
