% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocDenReg.R
\name{LocDenReg}
\alias{LocDenReg}
\title{Local density regression.}
\usage{
LocDenReg(
  xin = NULL,
  yin = NULL,
  hin = NULL,
  qin = NULL,
  xout = NULL,
  optns = list()
)
}
\arguments{
\item{xin}{A numeric vector holding the observations of the predictor.}

\item{yin}{A matrix or list holding the sample of observations of the response. If \code{yin} is a matrix, each row holds the observations of the response corresponding to a predictor value in \code{xin}.}

\item{hin}{A list holding the histograms of the response corresponding to each predictor value in \code{xin}.}

\item{qin}{A matrix or list holding the quantile functions of the response. If \code{qin} is a matrix, each row holds the quantile function corresponding to a predictor value in \code{xin}.}

\item{xout}{A numeric vector holding the output grid for the predictor. Default is \code{xin}.}

\item{optns}{A list of options control parameters specified by \code{list(name=value)}. See `Details'.}
}
\value{
A list containing the following components:
\item{xout}{Input \code{xout}.}
\item{dout}{A matrix or list holding the output densities corresponding to \code{xout}. If \code{dout} is a matrix, each row gives a density and the domain grid is given in \code{dSup}. If \code{dout} is a list, each element is a list of two components, \code{x} and \code{y}, giving the domain grid and density function values, respectively.}
\item{dSup}{A numeric vector giving the domain grid of \code{dout} when it is a matrix.}
\item{qout}{A matrix holding the quantile functions of the output densities. Each row corresponds to a value in \code{xout}.}
\item{qSup}{A numeric vector giving the domain grid of \code{qout}.}
\item{xin}{Input \code{xin}.}
\item{din}{Densities corresponding to the input \code{yin}, \code{hin} or \code{qin}.}
\item{qin}{Quantile functions corresponding to the input \code{yin}, \code{hin} or \code{qin}.}
\item{optns}{A list of control options used.}
}
\description{
Local Fréchet regression for densities with respect to \eqn{L^2}-Wasserstein distance.
}
\details{
Available control options are
\describe{
\item{bwReg}{A scalar used as the bandwidth or a character indicating the selection method: \code{"CV"} (default) or \code{"GCV"}.}
\item{kernelReg}{A character holding the type of kernel functions for local Fréchet regression for densities; \code{"rect"}, \code{"gauss"}, \code{"epan"}, \code{"gausvar"}, \code{"quar"} - default: \code{"gauss"}.}
\item{qSup}{A numeric vector holding the grid on [0,1] quantile functions take value on. Default is an equidistant grid.}
\item{nqSup}{A scalar giving the length of \code{qSup}. Default is 201.}
\item{lower}{A scalar with the lower bound of the support of the distribution. Default is \code{NULL}.}
\item{upper}{A scalar with the upper bound of the support of the distribution. Default is \code{NULL}.}
\item{bwRange}{Bandwidth selection range if \code{bwReg} equals \code{"CV"} or \code{"GCV"}.}
\item{bwDen}{The bandwidth value for the smoothed mean function; positive numeric - default: determine automatically based on the data-driven bandwidth selector proposed by Sheather and Jones (1991).}
\item{ndSup}{The number of support points the kernel density estimation; numeric - default: 101.}
\item{dSup}{User defined output grid for the support of kernel density estimation, it overrides \code{nRegGrid}; numeric - default: \code{NULL}}
\item{delta}{The size of the bin to be used; numeric - default: \code{diff(range(y))/1000}. It only works when the raw sample is available.}
\item{kernelDen}{A character holding the type of kernel functions for density estimation; \code{"rect"}, \code{"gauss"}, \code{"epan"}, \code{"gausvar"}, \code{"quar"} - default: \code{"gauss"}.}
\item{infSupport}{logical if we expect the distribution to have infinite support or not; logical - default: \code{TRUE}}
\item{denLowerThreshold}{\code{FALSE} or a positive value giving the lower threshold of the densities; default: \code{0.001 * mean(qin[,ncol(qin)] - qin[,1])}.}
}
}
\examples{
xin = seq(0,1,0.05)
yin = lapply(xin, function(x) {
  rnorm(100, rnorm(1,x + x^2,0.005), 0.05)
})
qSup = seq(0,1,0.02)
xout = seq(0,1,0.2)
res1 <- LocDenReg(xin=xin, yin=yin, xout=xout, optns = list(bw = 0.12, qSup = qSup))
plot(res1)
\donttest{
xout <- xin
hin = lapply(yin, function(y) hist(y, breaks = 50))
res2 <- LocDenReg(xin=xin, hin=hin, xout=xout, optns = list(qSup = qSup))
plot(res2)
}
}
\references{
\cite{Petersen, A., & Müller, H.-G. (2019). "Fréchet regression for random objects with Euclidean predictors." The Annals of Statistics, 47(2), 691--719.}
}
