% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessment_cooccurrences.R
\name{assessment_cooccurrences}
\alias{assessment_cooccurrences}
\title{Generate a species co-occurrence matrix from assessment inventories}
\usage{
assessment_cooccurrences(inventory_list)
}
\arguments{
\item{inventory_list}{A list of site inventories having the format of
\code{\link[=assessment_list_inventory]{assessment_list_inventory()}}}
}
\value{
A data frame with 13 columns:
\itemize{
\item target_species (character)
\item target_species_c (numeric)
\item target_species_nativity (character)
\item target_species_n (numeric)
\item cospecies_scientific_name (character)
\item cospecies_family (character)
\item cospecies_acronym (character)
\item cospecies_nativity (character)
\item cospecies_c (numeric)
\item cospecies_w (numeric)
\item cospecies_physiognomy (character)
\item cospecies_duration (character)
\item cospecies_common_name (character)
}
}
\description{
\code{assessment_coccurrences()} accepts a list of species inventories
downloaded from \href{https://universalfqa.org/}{universalfqa.org} and
returns a complete listing of all co-occurrences. Repeated co-occurrences
across multiple assessments are included, but self co-occurrences are not,
allowing for meaningful summary statistics to be computed.
}
\examples{
# assessment_cooccurrences is best used in combination with
# download_assessment_list() and assessment_list_inventory().

\donttest{
ontario <- download_assessment_list(database = 2)
ontario_invs <- assessment_list_inventory(ontario)
ontario_cooccurrences <- assessment_cooccurrences(ontario_invs)
}

}
