% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexing_functions.R
\name{index_fqa_transects}
\alias{index_fqa_transects}
\title{List all available public floristic quality transect assessments}
\usage{
index_fqa_transects(database_id)
}
\arguments{
\item{database_id}{A numeric identifier of the desired database, as specified
by \href{https://universalfqa.org/}{universalfqa.org}. The id numbers can
be viewed with the
\code{\link[=index_fqa_databases]{index_fqa_databases()}} function.}
}
\value{
A data frame with 5 columns:
\itemize{
  \item id (numeric)
  \item assessment (character)
  \item date (date)
  \item site (character)
  \item practitioner (character)
  }
}
\description{
For any given database, \code{index_fqa_transects()} produces a data frame
of all floristic quality transect assessments publicly available at
\href{https://universalfqa.org/}{universalfqa.org}.
}
\examples{
\donttest{
databases <- index_fqa_databases()
# Note that the 2017 Chicago database has id_number 149
chicago_2017_transects <- index_fqa_transects(149)
}

}
