% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{unassigned_plants}
\alias{unassigned_plants}
\title{Return Data Frame of Plant Species That Have No C Value}
\usage{
unassigned_plants(x, key = "name", db)
}
\arguments{
\item{x}{A data frame containing a list of plant species. This data frame
must have one of the following columns: \code{name} or \code{acronym}. For cover-weighted or
relative functions, this data frame must also have a column called \code{cover} containing
cover values and ideally a column containing plot IDs.}

\item{key}{A character string representing the column that will be used to join
the input data frame \code{x} with the regional FQA database. If a value is not specified, the
default is \code{"name"}. \code{"name"} and \code{"acronym"} are the only acceptable
values for \code{key}.}

\item{db}{A character string representing the regional FQA database to use. See
\code{db_names} for a list of potential values and the \code{fqadata} R package
where the databases are hosted.}
}
\value{
A data frame
}
\description{
Some regional FQA lists contain species which have not been assigned a C Value.
\code{unassigned_plants} returns a data frame of plants in \code{x} that can be matched
to a regional FQA database but have no C Value. These observations can optionally
be discarded in other \code{fqacalc} functions.
}
\examples{
no_c_test <- data.frame(name = c("ABRONIA FRAGRANS", "ACER GLABRUM",
"ACER GRANDIDENTATUM", "ACER PLATANOIDES"))

unassigned_plants(no_c_test, key = "name", db = "montana_2017")

}
