% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpaccess.R
\name{Fpop_w}
\alias{Fpop_w}
\title{Fpop_w}
\usage{
Fpop_w(x, w, lambda, mini = min(x), maxi = max(x))
}
\arguments{
\item{x}{a numerical vector to segment.}

\item{w}{a numerical vector of weights (values should be larger than 0).}

\item{lambda}{the penalty per changepoint (see Maidstone et al. 2016).}

\item{mini}{minimum mean segment value to consider in the optimisation.}

\item{maxi}{maximum mean segment value to consider in the optimisation.}
}
\value{
return a list with a vector t.est containing the position of the change-points, the number of changes K and, the cost J.est.
}
\description{
Function to run the Fpop algorithm (Maidstone et al. 2016) with weights. It uses functional pruning and optimal partionning. It optimizes the weighted L2-loss (\eqn{w_i (x_i - \mu)2}) for a penalty lambda per change.
}
\examples{
x <- c(rnorm(100), rnorm(10^3)+2, rnorm(1000)+1)
est.sd <- sdDiff(x) ## rough estimate of std-deviation
res <- Fpop_w(x=x, w=rep(1, length(x)), lambda=2*est.sd^2*log(length(x)))
smt <- getSMT(res)
}
