% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forplo.R
\name{forplo}
\alias{forplo}
\title{forplo - flexible forest plots with R}
\usage{
forplo(
  mat,
  em = "OR",
  row.labels = NULL,
  linreg = FALSE,
  prop = FALSE,
  pval = NULL,
  xlim = xlimits,
  fliprow = NULL,
  flipbelow1 = FALSE,
  flipsymbol = "*",
  ci.sep = "-",
  ci.lwd = 1.5,
  ci.edge = TRUE,
  font = "Calibri",
  groups = NULL,
  grouplabs = NULL,
  group.space = 1,
  group.italics = FALSE,
  left.align = FALSE,
  favorlabs = NULL,
  sort = FALSE,
  char = 20,
  size = 1.5,
  col = 1,
  insig.col = "gray",
  scaledot.by = NULL,
  scaledot.factor = 0.75,
  diamond = NULL,
  diamond.col = col,
  diamond.line = TRUE,
  add.columns = NULL,
  add.colnames = NULL,
  right.bar = FALSE,
  rightbar.ticks = 0,
  left.bar = TRUE,
  leftbar.ticks = 0,
  shade.every = NULL,
  shade.col = "red",
  shade.alpha = 0.05,
  fill.by = NULL,
  fill.colors = NULL,
  margin.left = NULL,
  margin.top = 0,
  margin.bottom = 2,
  margin.right = 10,
  horiz.bar = FALSE,
  title = NULL,
  save = FALSE,
  save.path = NULL,
  save.name = NULL,
  save.type = "png",
  save.width = 9,
  save.height = 4.5
)
}
\arguments{
\item{mat}{An n*3 data.frame or matrix, or a regression model of class lm, glm or coxph.}

\item{em}{Effect measure to be displayed (e.g. OR, RR, HR).}

\item{row.labels}{Labels to display as variable names (character vector of length nrow(mat)).}

\item{linreg}{Set to TRUE if the estimates are from a linear regression model.}

\item{prop}{Set to TRUE if the estimates are proportions.}

\item{pval}{A numeric or character vector of same length as nrow(mat), with p-values.}

\item{xlim}{A numeric vector of length 2 indicating the limits of the x-axis.}

\item{fliprow}{A numeric vector indicating which estimates should be inverted (only for ratios).}

\item{flipbelow1}{Set to TRUE to invert all ratios below 1.}

\item{flipsymbol}{A symbol to display besides inverted estimates. Asterisk by default.}

\item{ci.sep}{The separator between confidence intervals. Dash by default.}

\item{ci.lwd}{Line width for the confidence interval 'whiskers'.}

\item{ci.edge}{Set to FALSE to remove the 90 degree edges at the end of the CI whiskers.}

\item{font}{Controls the font family. 'Calibri' by default. Note: monospaced fonts work poorly.}

\item{groups}{A numeric vector of length nrow(mat) indicating group membership of each element.}

\item{grouplabs}{A character vector of equal length to the number of groups, with the labels of each group.}

\item{group.space}{A single numeric value to indicate how much empty rows should be between grouped estimates.}

\item{group.italics}{Set to TRUE to italicize the group labels.}

\item{left.align}{Set to TRUE to left align variable and group labels.}

\item{favorlabs}{A character vector of length 2, providing labels for underneath the x-axis (e.g. c('favors control','favors intervention')).}

\item{sort}{Set to TRUE to sort the rows by effect size (not compatible with groups or diamond).}

\item{char}{Controls the character to display for the dots. Equivalent to pch in the base R plot function.}

\item{size}{Controls the size of the dots. Equivalent to cex in the base R plot function.}

\item{col}{Controls the color of the dots. Equivalent to col in the base R plot function.}

\item{insig.col}{Controls the color of the CI whiskers when crossing the null line. Gray by default.}

\item{scaledot.by}{Numeric vector of length nrow(mat) to indicate relative importance of each variable (e.g. sample size, weight).}

\item{scaledot.factor}{Scaling factor (scalar) for scaledot.by, to adapt the size of all scaled dots at once.}

\item{diamond}{Numeric vector indicating the rows that should be displayed as diamonds (e.g. for meta-analytic estimates).}

\item{diamond.col}{Controls the color of the diamonds.}

\item{diamond.line}{Shows a dotted vertical line through the last diamond. Set to FALSE to disable.}

\item{add.columns}{A data.frame of nrow(mat) with additional columns to add to the right of the plot.}

\item{add.colnames}{A character vector of length ncol(add.columns) with column labels for these columns.}

\item{right.bar}{Set to TRUE to show a vertical bar directly to the left of the estimates.}

\item{rightbar.ticks}{Controls the tick marks on the right axis.}

\item{left.bar}{Set to FALSE to remove the horizontal bar on the left axis.}

\item{leftbar.ticks}{Controls the tick marks on the left axis.}

\item{shade.every}{Controls row shading option. A value of 1 colors every other row, a value of 2 per blocks of 2, etc. Non-integer values also allowed.}

\item{shade.col}{Controls the default row shading color. Default is 'red'.}

\item{shade.alpha}{Controls the transparency of the row shading color. Default is 0.05.}

\item{fill.by}{Numeric vector of length nrow(mat) indicating color group membership of each element.}

\item{fill.colors}{Character vector of length unique(fill.by), with colors for each color group.}

\item{margin.left}{Controls size of left margin.}

\item{margin.top}{Controls size of top margin.}

\item{margin.bottom}{Controls size of bottom margin.}

\item{margin.right}{Controls size of right margin.}

\item{horiz.bar}{Set to TRUE to display a horizontal bar below the plot.}

\item{title}{Title to display above the plot. Equivalent to title in the base R plot function.}

\item{save}{Set to TRUE to save the plot (also requires save.name and save.path) in 300 dpi resolution.}

\item{save.path}{Indicates folder where the plot should be saved.}

\item{save.name}{Name of the plot (should not include filetype extension).}

\item{save.type}{Filetype of the saved plot. Default is .png, but also supports .wmf on Windows.}

\item{save.width}{Width of the saved plot in inches. Default is 9.}

\item{save.height}{Height of the saved plot in inches. Default is 4.5.}
}
\value{
The function plots in the user's plot window, but does not return anything.
}
\description{
forplo is an R package meant to simplify the creation and customization of forest plots (alternatively called dot-and-whisker plots).
Input classes accepted by forplo are \code{data.frame}, \code{matrix}, \code{lm}, \code{glm}, and \code{coxph}. forplo was written in base R and does not depend on other packages.
For extensive examples and how to use all arguments for customization, please refer to the package vignette.
}
\examples{
#==== Create some regression models ==========
mod1 <- lm(Sepal.Length~Sepal.Width+Species+Petal.Width+Petal.Length,iris)

#==== Example forest plots====================
# default plot for linear regression model
forplo(mod1,font='Helvetica')

# customized plot for linear regression model
forplo(mod1,
       font='Helvetica',
       row.labels=c('Sepal width','Versicolor','Virginica','Petal width','Petal length'),
       groups=c(1,2,2,3,3),
       grouplabs=c('Sepal traits','Species','Petal traits'),
       shade.every=1,
       shade.col='gray',
       left.align=TRUE,
       xlim=c(-2,2),
       title='Linear regression with grouped estimates')

## More examples are given in the vignette.
}
