% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.one.sided.R, R/is.two.sided.R
\docType{methods}
\name{.is.one.sided}
\alias{.is.one.sided}
\alias{is.one.sided}
\alias{is.one.sided,formula-method}
\alias{is.one.sided,call-method}
\alias{is.one.sided,<--method}
\alias{.is.one.sided.plural}
\alias{is.one.sided,expression-method}
\alias{is.one.sided,list-method}
\alias{is.one.sided,ANY-method}
\alias{.is.two.sided}
\alias{is.two.sided}
\alias{is.two.sided,}
\alias{is.two.sided-methods}
\alias{is.two.sided,formula-method}
\alias{is.two.sided,call-method}
\alias{is.two.sided,<--method}
\alias{.is.two.sided.plural}
\alias{is.two.sided,expression-method}
\alias{is.two.sided,list-method}
\alias{is.two.sided,ANY-method}
\title{Determine if an object is one- or two- sided.
 
Test whether a object (typically formula, call or expression) is one-, e.g. 
\code{ ~ RHS } or two-sided, e.g. \code{LHS = RHS}}
\usage{
.is.one.sided(x, ...)

is.one.sided(x, ...)

\S4method{is.one.sided}{formula}(x, ...)

\S4method{is.one.sided}{call}(x, ...)

\S4method{is.one.sided}{`<-`}(x, ...)

.is.one.sided.plural(x, ...)

\S4method{is.one.sided}{expression}(x, ...)

\S4method{is.one.sided}{list}(x, ...)

\S4method{is.one.sided}{ANY}(x, ...)

.is.two.sided(x)

is.two.sided(x, ...)

\S4method{is.two.sided}{formula}(x)

\S4method{is.two.sided}{call}(x)

\S4method{is.two.sided}{`<-`}(x)

.is.two.sided.plural(x, ...)

\S4method{is.two.sided}{expression}(x, ...)

\S4method{is.two.sided}{list}(x, ...)

\S4method{is.two.sided}{ANY}(x)
}
\arguments{
\item{x}{object to test for one-sidedness.}

\item{...}{arguments passed to called functions

\code{.is.one.sided} and \code{.is.one.sided.plural} are not exported and 
should not be relied upon. This may change in the near future.}
}
\value{
logical; whether \code{x} is one sided or
}
\description{
Determine if an object is one- or two- sided.
 
Test whether a object (typically formula, call or expression) is one-, e.g. 
\code{ ~ RHS } or two-sided, e.g. \code{LHS = RHS}
}
