% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASM_Server.R
\name{ASM_read_app_state}
\alias{ASM_read_app_state}
\title{Read App State From Yaml Files}
\usage{
ASM_read_app_state(sources = NULL)
}
\arguments{
\item{sources}{Vector of at corresponds with the ID used to call the modules UI elements}
}
\value{
list with the following elements
\itemize{
  \item{isgood:}       Boolean indicating the exit status of the function.
  \item{msgs:}         Messages to be passed back to the user.
  \item{src_list:}     List containing the result of reading all of the sources.
  \item{yaml_res:}     Lists with elements for each module ID found in src_list with elements holding the modules configuration file \code{"mod_cfg"} and the modules formods configuration file \code{"fm_cfg"}
}
}
\description{
Reads in the app state from yaml files.
}
\examples{
res = ASM_read_app_state(sources=system.file(package="formods", "preload", "UD_preload.yaml"))
}
