% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tostring.R
\name{open_font_dev}
\alias{open_font_dev}
\alias{close_font_dev}
\alias{debug_font_dev}
\alias{undebug_font_dev}
\title{Activate font state}
\usage{
open_font_dev(fontspec, silent = FALSE)

close_font_dev()

debug_font_dev()

undebug_font_dev()
}
\arguments{
\item{fontspec}{(\code{font_spec})\cr a font_spec object specifying the font information to use for
calculating string widths and heights, as returned by \code{\link[=font_spec]{font_spec()}}.}

\item{silent}{(\code{logical(1)})\cr If \code{FALSE}, the default, a warning will be
emitted if this function switches away from an active graphics device.}
}
\value{
\itemize{
\item \code{open_font_dev} returns a logical value indicating whether a \emph{new} pdf device was opened.
\item \code{close_font_dev}, \code{debug_font_dev} and \code{undebug_font_dev} return \code{NULL}.
}

In all cases the value is returned invisibly.
}
\description{
Activate font state
}
\details{
The font device state is an environment with
four variables guaranteed to be set:

\describe{
\item{\code{open}}{(\code{logical(1)})\cr whether a device is already open with font info}
\item{\code{fontspec}}{(\code{font_spec})\cr the font specification, if any, that is currently active (\code{list()} if none is).}
\item{\code{spacewidth}}{(\code{numeric(1)})\cr the width of the space character in the currently active font.}
\item{\code{ismonospace}}{(\code{logical(1)})\cr whether the specified font is monospaced.}
}

\code{open_font_dev} opens a pdf device with the specified font
only if there is not one currently open with the same font.
If a new device is opened, it caches \code{spacewidth} and
\code{ismonospace} for use in \code{nchar_ttype}).

\code{close_font_dev} closes any open font state device
and clears the cached values.

\code{debug_font_dev} and \code{undebug_font_dev} activate and deactivate, respectively,
logging of where in the call stack font devices are being opened.
}
\examples{
open_font_dev(font_spec("Times"))
nchar_ttype("Hiya there", font_spec("Times"))
close_font_dev()

}
