% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formats.R
\name{accounting}
\alias{accounting}
\alias{accounting.character}
\alias{accounting.default}
\title{Numeric vector with accounting format}
\usage{
accounting(x, digits = 2L, format = "f", big.mark = ",", ...)

\method{accounting}{default}(x, digits = 2L, format = "f", big.mark = ",",
  ...)

\method{accounting}{character}(x, digits = max(get_digits(x)), format = "f",
  big.mark = ",", ...)
}
\arguments{
\item{x}{a numeric vector.}

\item{digits}{an integer to indicate the number of digits of the percentage string.}

\item{format}{format type passed to \code{\link{formatC}}.}

\item{big.mark}{thousands separator}

\item{...}{additional parameters passed to \code{formattable}.}
}
\description{
Numeric vector with accounting format
}
\examples{
accounting(15320)
accounting(-12500)
accounting(c(1200, -3500, 2600), format = "d")
accounting(c("123,23.50", "(123.243)"))
}

