% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{Arima}
\alias{Arima}
\alias{print.ARIMA}
\alias{summary.Arima}
\alias{as.character.Arima}
\title{Fit ARIMA model to univariate time series}
\usage{
Arima(
  y,
  order = c(0, 0, 0),
  seasonal = c(0, 0, 0),
  xreg = NULL,
  include.mean = TRUE,
  include.drift = FALSE,
  include.constant,
  lambda = model$lambda,
  biasadj = FALSE,
  method = c("CSS-ML", "ML", "CSS"),
  model = NULL,
  x = y,
  ...
)
}
\arguments{
\item{y}{a univariate time series of class \code{ts}.}

\item{order}{A specification of the non-seasonal part of the ARIMA model:
the three components (p, d, q) are the AR order, the degree of differencing,
and the MA order.}

\item{seasonal}{A specification of the seasonal part of the ARIMA model,
plus the period (which defaults to frequency(y)). This should be a list with
components order and period, but a specification of just a numeric vector of
length 3 will be turned into a suitable list with the specification as the
order.}

\item{xreg}{Optionally, a numerical vector or matrix of external regressors, which
must have the same number of rows as y. It should not be a data frame.}

\item{include.mean}{Should the ARIMA model include a mean term? The default
is \code{TRUE} for undifferenced series, \code{FALSE} for differenced ones
(where a mean would not affect the fit nor predictions).}

\item{include.drift}{Should the ARIMA model include a linear drift term?
(i.e., a linear regression with ARIMA errors is fitted.)  The default is
\code{FALSE}.}

\item{include.constant}{If \code{TRUE}, then \code{include.mean} is set to
be \code{TRUE} for undifferenced series and \code{include.drift} is set to
be \code{TRUE} for differenced series. Note that if there is more than one
difference taken, no constant is included regardless of the value of this
argument. This is deliberate as otherwise quadratic and higher order
polynomial trends would be induced.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda="auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted values,
a regular back transformation will result in median forecasts. If biasadj is TRUE,
an adjustment will be made to produce mean forecasts and fitted values.}

\item{method}{Fitting method: maximum likelihood or minimize conditional
sum-of-squares. The default (unless there are missing values) is to use
conditional-sum-of-squares to find starting values, then maximum likelihood.}

\item{model}{Output from a previous call to \code{Arima}. If model is
passed, this same model is fitted to \code{y} without re-estimating any
parameters.}

\item{x}{Deprecated. Included for backwards compatibility.}

\item{...}{Additional arguments to be passed to \code{\link[stats]{arima}}.}
}
\value{
See the \code{\link[stats]{arima}} function in the stats package.
The additional objects returned are \item{x}{The time series data}
\item{xreg}{The regressors used in fitting (when relevant).}
\item{sigma2}{The bias adjusted MLE of the innovations variance.}
}
\description{
Largely a wrapper for the \code{\link[stats]{arima}} function in the stats
package. The main difference is that this function allows a drift term. It
is also possible to take an ARIMA model from a previous call to \code{Arima}
and re-apply it to the data \code{y}.
}
\details{
See the \code{\link[stats]{arima}} function in the stats package.
}
\examples{
library(ggplot2)
WWWusage \%>\%
  Arima(order=c(3,1,0)) \%>\%
  forecast(h=20) \%>\%
  autoplot

# Fit model to first few years of AirPassengers data
air.model <- Arima(window(AirPassengers,end=1956+11/12),order=c(0,1,1),
                   seasonal=list(order=c(0,1,1),period=12),lambda=0)
plot(forecast(air.model,h=48))
lines(AirPassengers)

# Apply fitted model to later data
air.model2 <- Arima(window(AirPassengers,start=1957),model=air.model)

# Forecast accuracy measures on the log scale.
# in-sample one-step forecasts.
accuracy(air.model)
# out-of-sample one-step forecasts.
accuracy(air.model2)
# out-of-sample multi-step forecasts
accuracy(forecast(air.model,h=48,lambda=NULL),
         log(window(AirPassengers,start=1957)))

}
\seealso{
\code{\link{auto.arima}}, \code{\link{forecast.Arima}}.
}
\author{
Rob J Hyndman
}
\keyword{ts}
