% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPerformanceSpaceMulti.R
\name{plotPerformanceSpaceMulti}
\alias{plotPerformanceSpaceMulti}
\title{Plots contours of the number of performance thresholds exceeded in the perturbation space}
\usage{
plotPerformanceSpaceMulti(
  performance,
  sim,
  perfThreshMin,
  perfThreshMax,
  attX = NULL,
  attY = NULL,
  attSlices = NULL,
  topReps = NULL,
  climData = NULL,
  col = NULL,
  axesPercentLabel = FALSE
)
}
\arguments{
\item{performance}{a list; each element of the list should be a performance metric. May be calculated using the function \code{runSystemModel}}

\item{sim}{a list; summary of the simulation containing the scenarios generated using the function \code{generateScenarios} that is used to run the system model using \code{runSystemModel}.
The summary of the simulation may be obtained by using the function \code{getSimSummary} on the full simulation. The summary object is much smaller in size for ease of storage and use with the performance 
plotting functions like \code{plotPerformanceSpace}.}

\item{perfThreshMin}{a vector; the minimum threshold value of each performance metric. The length of the vector should be equal to \code{length(performance)}. 
If the metric does not have a minimum threshold, specify the corresponding element in \code{perfThreshMin} as \code{NA}.}

\item{perfThreshMax}{a vector; the maximum threshold value of each performance metric. The length of the vector should be equal to \code{length(performance)}.
If the metric does not have a maximum threshold, specify the corresponding element in \code{perfThreshMax} as \code{NA}.}

\item{attX}{a string; the tag of the perturbed attribute to plot on the xaxis. The attribute must be one of the perturbed attributes of \code{sim}. 
Type \code{sim$expSpace$attPerturb} to view all perturbed attributes of \code{sim}. If \code{NULL} (default), the first perturbed attribute of \code{sim} will be used.}

\item{attY}{a string; the tag of the perturbed attribute to plot on the yaxis. The attribute must be another perturbed attribute of \code{sim}.
If \code{NULL}, the second perturbed attribute of \code{sim} will be used.}

\item{attSlices}{a list; used to subset perturbed attributes in \code{sim} for the plot. This argument would typically be used in cases where there are more than two perturbed attributes.
The elements of the list correspond to the perturbed attributes to be subsetted and must be named using the attribute tag. Each element may contain a single value or a two-element vector specifying the minimum-maximum values. 
If the element is a single value, the exposure space is sliced on this single value of the attribute. If minimum-maximum values are specified, the exposure space will be sliced to subset this range.
If \code{attSlices} includes \code{attX} or \code{attY}, these attributes will be sliced and the resulting plot will be a "zoomed-in" space.}

\item{topReps}{an integer (default is \code{NULL}); the number of "top" replicates in terms of simulation fitness to be used. If \code{topReps} is specified, \code{topReps}
number of replicates will be identified for each target and the average performance across these replicates will be plotted. If \code{NULL}, the average performance across all the replicates will be plotted.}

\item{climData}{data.frame; the values of \code{attX} and \code{attY} from other sources like climate models. This data will be plotted as points in the perturbation space.
If the \code{Name} of the data is available in the data.frame, the points will be identified using the \code{Name}. 
Please refer data provided with the package that may be loaded using \code{data("egClimData")} for an example of the expected format of \code{climData}.}

\item{col}{a vector of colours; The length of the vector should atleast be sufficient to assign unique colours to all
the different values in the generated plot. If \code{NULL}, the default foreSIGHT colours is used.}

\item{axesPercentLabel}{a logical flag; if TRUE x and y axes to be displayed in terms of percentage change instead of fraction}
}
\value{
The plot showing the number of thresholds exceeded and the ggplot object.
}
\description{
\code{plotPerformanceSpaceMulti} uses multiple system model performances calculated using the function \code{runSystemModel} and 
the summary of the simulation generated using the functions \code{generateScenarios} & \code{getSimSummary} as input to plot filled contours showing the 
number of performance thresholds exceeded in the perturbation space.
The user may specify the attributes to be used as the axes of the perturbation space.
}
\details{
If the space contains more than two perturbed attributes, the performance values are averaged across the perturbations in the attributes other than \code{attX} and \code{attY}.
The user may specify argument \code{attSlices} to slice the performance space at specific values of the other perturbed attributes. If \code{attSlices} are used to 
specify minimum-maximum values to subset other perturbed attributes, the performance values are averaged across the subsetted perturbations in these attributes. This function
cannot be used with \code{sim} perturbed on an "OAT" grid since contours of the number of performance thresholds exceeded cannot be calculated for an irregular perturbation space.
}
\examples{
# load example datasets
data("egSimPerformance")
data("egSimSummary")
data("egClimData")

plotPerformanceSpaceMulti(performance=egSimPerformance, sim=egSimSummary, 
perfThreshMin = c(NA, 0.80), perfThreshMax = c(30, NA))

#replot with axes as percentage changes
plotPerformanceSpaceMulti(performance=egSimPerformance, sim=egSimSummary, 
perfThreshMin = c(NA, 0.80), perfThreshMax = c(30, NA),axesPercentLabel=TRUE)

# add alternate climate data and specify different colours for the plot
plotPerformanceSpaceMulti(performance=egSimPerformance, sim=egSimSummary, 
                          perfThreshMin = c(NA, 0.80),perfThreshMax = c(30, NA), 
                          climData = egClimData, col = viridisLite::magma(3))

# example using simple scaled simulations
data("egScalPerformance")
data("egScalSummary")
data("egClimData")
plotPerformanceSpaceMulti(performance=egScalPerformance, sim=egScalSummary, 
                          perfThreshMin = c(NA, 0.80),perfThreshMax = c(30, NA), 
                          climData = egClimData)

# replot with axes as percentage changes (Note: modifies fractional change attributes only)
plotPerformanceSpaceMulti(performance=egScalPerformance, sim=egScalSummary, 
                          perfThreshMin = c(NA, 0.80),perfThreshMax = c(30, NA), 
                          climData = egClimData,axesPercentLabel=TRUE)
}
\seealso{
\code{runSystemModel}, \code{generateScenarios}, \code{getSimSummary}, \code{plotPerformanceSpace}
}
