% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_data.R
\name{combine_data}
\alias{combine_data}
\title{Combine Data Tables}
\usage{
combine_data(
  dt1,
  dt2,
  by = list(subj = "subj", block = "block", trial = "trial"),
  continuous = FALSE
)
}
\arguments{
\item{dt1}{A \code{data.table} of the class \code{fp.segm}, \code{fp.tl}, or \code{exp.prep}.}

\item{dt2}{A \code{data.table} of the class \code{fp.segm}, \code{fp.tl}, or \code{exp.prep}. Make
sure the two data.table have either the same number of rows or the same columns.}

\item{by}{A list of three variable names in the experimental data that reflect the
subj (subject number), block (block number), and trial (trial number) in the
force-plate data. This argument is only necessary for combining experimental
data with force-plate data.}

\item{continuous}{A logical value. Default is \code{FALSE}, meaning the variable for
the trials in the used experimental data.table counts for each block separately,
that is in each block it counts from 1 to the number of trials in that block. If
\code{TRUE} it is assumed that the trials are counted from 1 to the total number
of trials of a subject.}
}
\value{
A \code{data.table} either of the same class as \code{dt1} and \code{dt2}, if they
share the same class, or of the class \code{dt.comb}.
}
\description{
Combine two \code{data.table}s, either two force-plate data, two exeperimental data, or one
force-plate and one experimental data.
}
\author{
Raphael Hartmann & Anton Koger
}
