% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_series_manipulations.R
\name{reduce_frq}
\alias{reduce_frq}
\title{Reduce Sampling Frequency}
\usage{
reduce_frq(df, Hz = 200, measurement.col = NULL)
}
\arguments{
\item{df}{Data frame or tibble in the below mentioned format.}

\item{Hz}{Numeric value of desired frequency. Default \code{200}}

\item{measurement.col}{Character string. If \code{measurement.col} is not defined, the whole input data frames will be
treated as if it was just one single time series. This is okay for data frames like that indeed only contain one
time series, but for data frames
with multiple time series, a grouping column needs to be defined. Default: \code{NULL}}
}
\value{
Returns a tibble reduced to the desired frequency in the following format:\tabular{cc}{
   \strong{\code{t}} \tab \strong{\code{y}} \cr
   \code{t.1} \tab \code{y.1} \cr
   \code{...} \tab \code{...} \cr
   \code{t.n} \tab \code{y.n} \cr
}


or, if \code{measurement.col} is not \code{NULL}, then\tabular{ccc}{
   \strong{\code{t}} \tab \strong{\code{y}} \tab \strong{\code{measurement.col}} \cr
   \code{t.1} \tab \code{y.1} \tab \code{...} \cr
   \code{...} \tab \code{...} \tab \code{...} \cr
   \code{t.n} \tab \code{y.n} \tab \code{...} \cr
}
}
\description{
Reduces the sampling frequency to a certain Hz value. If the desired frequency is smaller than the
original frequency, the data remains unchanged.
}
\details{
The input data frame or tibble should have the following format:\tabular{cc}{
   \strong{\code{t}} \tab \strong{\code{y}} \cr
   \code{t.1} \tab \code{y.1} \cr
   \code{...} \tab \code{...} \cr
   \code{t.n} \tab \code{y.n} \cr
}


or, if \code{measurement.col} is not \code{NULL}, then\tabular{ccc}{
   \strong{\code{t}} \tab \strong{\code{y}} \tab \strong{\code{measurement.col}} \cr
   \code{t.1} \tab \code{y.1} \tab \code{...} \cr
   \code{...} \tab \code{...} \tab \code{...} \cr
   \code{t.n} \tab \code{y.n} \tab \code{...} \cr
}


Since, when not \code{NULL}, the \code{measurement.col} is called by its character string, the position of the column does not matter, except it
must not be among the first two columns which are reserved for \code{t} and \code{y}.

All columns except the first two are removed. Values in \code{t} are expected to be in m.secs.
}
\examples{
require(dplyr)
# Using the forceR::df.all dataset that was
# simulated with forceR::simulate_bites()

# reduce sampling frequency to 200 Hz
df.all.200 <- reduce_frq(df = df.all,
                         Hz = 200,
                         measurement.col = "measurement")

plot(df.all.200 \%>\%
       filter(measurement == "m_02") \%>\%
       select(t, y),
     type = "l", col = "black")
lines(df.all.200 \%>\%
       filter(measurement == "m_01") \%>\%
       select(t, y),
     type = "l", col = "blue")
}
