% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anylm.R
\name{anylm}
\alias{anylm}
\title{Analysis of linear regression for time series in batch}
\usage{
anylm(
  df,
  xd = 2,
  yd = 3,
  zd = NULL,
  td = NULL,
  mi = 1,
  range.y = "interval",
  range.x = "interval",
  nperm = 99,
  showpage = TRUE,
  scint = FALSE,
  dign = 1,
  zfill = "lightgray",
  ppsize = 2,
  showinfo = TRUE,
  ptsize = 12,
  pncol = NULL
)
}
\arguments{
\item{df}{dataframe of time series.}

\item{xd}{species or columns for x axis, vector of number or colnames. Default vaule is '2'.}

\item{yd}{species or columns for y axis, vector of number or colnames. Default vaule is '3'.}

\item{zd}{species or columns to fill points, vector of number or colnames. Default vaule is 'NULL'.
If zd is setted, labels for scaled color represent Percentile value (0, 0.25, 0.5,0.75, 1).}

\item{td}{1 column to group data, number or colname. Default vaule is 'NULL'.}

\item{mi}{index (1~4) of methods: 1. ordinary least squares (OLS); 2. major axis (MA); 3. standard major axis (SMA);
4. and ranged major axis (RMA). Refered from R package 'lmodel2'. Default vaule is '1'.}

\item{range.y}{Parametres for ranged major axis regression (RMA). If range.y = NULL and range.x = NULL, RMA will not be computed.
If only one of them is NULL, the program will stop. If range.y = "relative": variable y has a true zero (relative-scale variable).
If range.y = "interval": variable y possibly includes negative values (interval-scale variable).
If range.x = "relative": variable x has a true zero (relative-scale variable).
If range.x = "interval": variable x possibly includes negative values (interval-scale variable). Refered from R package 'lmodel2'.}

\item{range.x}{Parametres, please see 'range.y'.}

\item{nperm}{Number of permutations for the tests. If nperm = 0, tests will not be computed. Refered from R package 'lmodel2'.}

\item{showpage}{logical value for showing all plots. If TRUE, print all plot in 1 page. Default vaule is 'TRUE'.}

\item{scint}{logical value for displaying scientific notion in legend and plot title. Default vaule is 'FALSE'.}

\item{dign}{numeric value for digists in legend and plot title. Default vaule is '1'.}

\item{zfill}{color for points, only valid when zd is NULL. Default vaule is "lightgray".}

\item{ppsize}{size for points. Default vaule is "lightgray".}

\item{showinfo}{logical value for displaying regression information in plot title. Default vaule is 'TRUE'.}

\item{ptsize}{font size for plot title. Default vaule is '12'.}

\item{pncol}{number of columns for plots in page. Refered from R package 'gridExtra'. Default vaule is 'NULL'.}
}
\value{
a list contains: data_list, lm_df, lm_list, plot_list, all_plot.\cr
data_list: a list contains data for linear regression.\cr
lm_df: a dataframe for key results of linear regression. row index of lm_df corresponds to 'id' of plot in 'all_plot'.\cr
lm_list: a list contains detail results of linear regression.\cr
plot_list: a list contains plots for linear regression. \cr
all_plot: a page for all plots in 'plot_list'.\cr
To see page, please use this function: 'gridExtra::grid.arrange(grobs=...)'.\cr
To see page, please use this 2-lines function:\cr
'g=gridExtra::arrangeGrob(grobs=...)',\cr
'ggplot2::ggsave(filename = "example.jpg", plot =g)'.\cr
'id' of plot corresponds to row index of 'lm_df'.\cr
}
\description{
Analyse linear regression for time series in batch
}
\details{
X axis, Y axis, scaled color for points are flexible for multiple columns.
Data could also be grouped according to 1 column. \cr
}
\examples{
anylm(aqi, xd=c(2,3), yd=6, zd=4, td=NULL, dign=3)
}
