% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loh.R
\name{loh}
\alias{loh}
\title{Calculate OH reactivity}
\usage{
loh(
  df,
  unit = "ppbv",
  t = 25,
  p = 101.325,
  stcd = FALSE,
  sortd = TRUE,
  colid = 1,
  atk = TRUE,
  chn = FALSE
)
}
\arguments{
\item{df}{dataframe contains time series.}

\item{unit}{unit for VOC concentration. A character vector from these options: "ugm" or "ppbv". "ugm" means ug/m3. "ppbv" means part per billion volumn.}

\item{t}{Temperature, in Degrees Celsius, used to convert data in 
micrograms per cubic meter to standard conditions 
(25 Degrees Celsius, 101.325 kPa). By default, t equals to 25 Degrees Celsius.}

\item{p}{Pressure, in kPa, used to convert data in micrograms per cubic meter 
to standard conditions (25 Degrees Celsius, 101.325 kPa). 
By default, p equals to 101.325 kPa.}

\item{stcd}{logical. Does it output the concentration in standard condition? 
The default vaule is FALSE.}

\item{sortd}{logical value. It determines whether the VOC species
are sorted or not. By default, sortd has value "TRUE".
If TRUE, VOC species in time series will be arranged according to VOC group,
 relative molecular weight, and OH Rate Constant.}

\item{colid}{column index for date-time. The default value is 1.}

\item{atk}{logical. use kOH value from atk or not? If not, kOH comes from 'AopWin v1.92' will be used. The default vaule is TRUE.}

\item{chn}{logical. Dose colnames present as Chinese? The default vaule is FALSE.}
}
\value{
a list contains 5 tables:
KOH_Result: matched KOH value result;
LOH_Result: LOH time series of VOC by species;
LOH_Result_mean: the average value and proportion of LOH of VOC by species (sorted from large to small);
LOH_Result_group: LOH time series of VOC classified by groups;
LOH_Result_group_mean: the average value and proportion of LOH of VOC according to major groups (sorted from large to small).
}
\description{
Calculate OH reactivity of VOC time series in 25 degree celsius. 
Note: for Chinese VOC name, please also use English punctuation.
}
\details{
The CAS number is matched for each VOC speices (from column name), and the
OH Rate Constant is matched through the CAS number and used for time series calculation. \cr
The OH Rate Constant comes from 'AopWin v1.92' in 25 degree celsius.
Note: If input VOC species contain M,P-xylene, it will be automatically divided into m-xylene and P-xylene evenly.
}
