% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/penalty_matrix_methods.R
\name{penalty_matrix}
\alias{penalty_matrix}
\alias{penalty_matrix.HRF}
\alias{penalty_matrix.BSpline_HRF}
\alias{penalty_matrix.Tent_HRF}
\alias{penalty_matrix.FIR_HRF}
\alias{penalty_matrix.SPMG2_HRF}
\alias{penalty_matrix.SPMG3_HRF}
\alias{penalty_matrix.Fourier_HRF}
\alias{penalty_matrix.Daguerre_HRF}
\title{Generate penalty matrix for regularization}
\usage{
penalty_matrix(x, ...)

\method{penalty_matrix}{HRF}(x, order = 2, ...)

\method{penalty_matrix}{BSpline_HRF}(x, order = 2, ...)

\method{penalty_matrix}{Tent_HRF}(x, order = 2, ...)

\method{penalty_matrix}{FIR_HRF}(x, order = 2, ...)

\method{penalty_matrix}{SPMG2_HRF}(x, order = 2, shrink_deriv = 2, ...)

\method{penalty_matrix}{SPMG3_HRF}(x, order = 2, shrink_deriv = 2, ...)

\method{penalty_matrix}{Fourier_HRF}(x, order = 2, ...)

\method{penalty_matrix}{Daguerre_HRF}(x, order = 2, ...)
}
\arguments{
\item{x}{The HRF object or basis specification}

\item{...}{Additional arguments passed to specific methods}

\item{order}{Integer specifying the order of the penalty (default: 2)}

\item{shrink_deriv}{Numeric; penalty weight for derivative terms in SPMG2/SPMG3 bases (default: 2)}
}
\value{
A symmetric positive definite penalty matrix of dimension nbasis(x) × nbasis(x)
}
\description{
Generate a penalty matrix for regularizing HRF basis coefficients. The penalty matrix
encodes shape priors that discourage implausible or overly wiggly HRF estimates.
Different HRF types use different penalty structures:

\itemize{
  \item{FIR/B-spline/Tent bases: Roughness penalties based on discrete derivatives}
  \item{SPM canonical + derivatives: Differential shrinkage of derivative terms}
  \item{Fourier bases: Penalties on high-frequency components}
  \item{Daguerre bases: Increasing weights on higher-order terms}
  \item{Default: Identity matrix (ridge penalty)}
}
}
\details{
The penalty matrix R is used in regularized estimation as lambda * h^T R h, where h are
the basis coefficients and lambda is the regularization parameter. Well-designed penalty
matrices can significantly improve HRF estimation by encoding smoothness or other
shape constraints.
}
\examples{
# FIR basis with smoothness penalty
fir_hrf <- HRF_FIR
R_fir <- penalty_matrix(fir_hrf)

# B-spline basis with second-order smoothness
bspline_hrf <- HRF_BSPLINE  
R_bspline <- penalty_matrix(bspline_hrf, order = 2)

# SPM canonical with derivative shrinkage
spmg3_hrf <- HRF_SPMG3
R_spmg3 <- penalty_matrix(spmg3_hrf, shrink_deriv = 4)

}
\seealso{
[nbasis()], [HRF_objects]

Other hrf: 
\code{\link{HRF_objects}},
\code{\link{deriv}()}
}
\concept{hrf}
