% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/hrf_from_coefficients.R
\name{hrf_from_coefficients}
\alias{hrf_from_coefficients}
\alias{hrf_from_coefficients.HRF}
\title{Combine HRF Basis with Coefficients}
\usage{
hrf_from_coefficients(hrf, h, ...)

\method{hrf_from_coefficients}{HRF}(hrf, h, name = NULL, ...)
}
\arguments{
\item{hrf}{An object of class `HRF`.}

\item{h}{Numeric vector of length `nbasis(hrf)` giving the weights.}

\item{...}{Reserved for future extensions.}

\item{name}{Optional name for the resulting HRF.}
}
\value{
A new `HRF` object with `nbasis = 1`.
}
\description{
Create a new HRF by linearly weighting the basis functions of an existing HRF.
Useful when coefficients have been estimated for an FIR/bspline/SPMG3 basis
and one wants a single functional HRF.
}
\examples{
# Create a custom HRF from SPMG3 basis coefficients
coeffs <- c(1, 0.2, -0.1)  # Main response + slight temporal shift - dispersion
custom_hrf <- hrf_from_coefficients(HRF_SPMG3, coeffs)

# Evaluate the custom HRF
t <- seq(0, 20, by = 0.1)
response <- evaluate(custom_hrf, t)

# Create from FIR basis
fir_coeffs <- c(0, 0.2, 0.5, 1, 0.8, 0.4, 0.1, 0, 0, 0, 0, 0)
custom_fir <- hrf_from_coefficients(HRF_FIR, fir_coeffs)
}
