% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityMetrics.R
\name{fmpc_security_dividends}
\alias{fmpc_security_dividends}
\title{Historical security dividend data}
\usage{
fmpc_security_dividends(
  symbols = "AAPL",
  startDate = Sys.Date() - 360,
  endDate = Sys.Date()
)
}
\arguments{
\item{symbols}{one or more symbols from the FMP available list that can be
found using \code{\link{fmpc_symbols_by_market}}. A valid API token must be
set in order to enable functionality. See documentation for setting a token
under \code{\link{fmpc_set_token}}.}

\item{startDate}{filter start date in yyyy-mm-dd format.}

\item{endDate}{filter end date in yyyy-mm-dd format.}
}
\value{
a data frame of dividend history that includes payment date, record
date, and declaration date
}
\description{
Pulls dividends for a list of securities. Data includes dividend, adjusted
dividend, payment date, record date, and declaration date
}
\section{Warning}{
 Each symbol is a separate API call. If the API token has
monthly limits, this should be considered before making a bulk request
}

\examples{


\dontrun{

# Setting API key to DEMO allows for AAPL only
fmpc_set_token()
fmpc_security_dividends('AAPL')

# For multiple symbols, set a valid API Token
fmpc_set_token('FMPAPIKEY')
fmpc_security_dividends(c('AAPL','MSFT','SPY'), startDate = '2010-01-01')

}
}
