% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_rgl}
\alias{plot_rgl}
\alias{lines_rgl}
\alias{lines_rgl.fm_segm}
\alias{plot_rgl.fm_mesh_2d}
\alias{plot_rgl.fm_segm}
\alias{plot_rgl.fm_segm_list}
\alias{lines_rgl.fm_segm_list}
\title{Low level triangulation mesh plotting}
\usage{
plot_rgl(x, ...)

lines_rgl(x, ..., add = TRUE)

\method{lines_rgl}{fm_segm}(
  x,
  loc = NULL,
  col = NULL,
  colors = c("black", "blue", "red", "green"),
  ...,
  add = TRUE
)

\method{plot_rgl}{fm_mesh_2d}(
  x,
  col = "white",
  color.axis = NULL,
  color.n = 512,
  color.palette = cm.colors,
  color.truncate = FALSE,
  alpha = NULL,
  lwd = 1,
  specular = "black",
  draw.vertices = TRUE,
  draw.edges = TRUE,
  draw.faces = TRUE,
  draw.segments = draw.edges,
  size = 2,
  edge.color = rgb(0.3, 0.3, 0.3),
  t.sub = seq_len(nrow(x$graph$tv)),
  visibility = "",
  S = deprecated(),
  add = FALSE,
  ...
)

\method{plot_rgl}{fm_segm}(x, ..., add = FALSE)

\method{plot_rgl}{fm_segm_list}(x, ...)

\method{lines_rgl}{fm_segm_list}(x, ...)
}
\arguments{
\item{x}{A \code{fm_mesh_2d()} object}

\item{\dots}{Additional parameters passed to and from other methods.}

\item{add}{If \code{TRUE}, adds to the current plot instead of starting a
new one.}

\item{loc}{Point locations to be used if \code{x$loc} is \code{NULL}.}

\item{col}{Segment color specification.}

\item{colors}{Colors to cycle through if \code{col} is \code{NULL}.}

\item{color.axis}{The min/max limit values for the color mapping.}

\item{color.n}{The number of colors to use in the color palette.}

\item{color.palette}{A color palette function.}

\item{color.truncate}{If \code{TRUE}, truncate the colors at the color axis
limits.}

\item{alpha}{Transparency/opaqueness values. See \code{rgl.material}.}

\item{lwd}{Line width for edges. See \code{rgl.material}.}

\item{specular}{Specular color. See \code{rgl.material}.}

\item{draw.vertices}{If \code{TRUE}, draw triangle vertices.}

\item{draw.edges}{If \code{TRUE}, draw triangle edges.}

\item{draw.faces}{If \code{TRUE}, draw triangles.}

\item{draw.segments}{If \code{TRUE}, draw boundary and interior constraint
edges more prominently.}

\item{size}{Size for vertex points.}

\item{edge.color}{Edge color specification.}

\item{t.sub}{Optional triangle index subset to be drawn.}

\item{visibility}{If "front" only display mesh faces with normal pointing
towards the camera.}

\item{S}{Deprecated.}
}
\value{
An rgl device identifier, invisibly.
}
\description{
Plots a triangulation mesh using \code{rgl}.
}
\examples{
\donttest{
if (interactive() && require("rgl")) {
  mesh <- fm_rcdt_2d(globe = 10)
  plot_rgl(mesh, col = mesh$loc[, 1])
}
}
}
\seealso{
\code{\link[=plot.fm_mesh_2d]{plot.fm_mesh_2d()}}
}
\author{
Finn Lindgren \href{mailto:Finn.Lindgren@gmail.com}{Finn.Lindgren@gmail.com}
}
