% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FME.R
\name{fme}
\alias{fme}
\title{Computes FMEs.}
\usage{
fme(
  model,
  data,
  target,
  feature,
  step.size,
  ep.method = "none",
  compute.nlm = FALSE,
  nlm.intervals = 1
)
}
\arguments{
\item{model}{The (trained) model, with the ability to predict on new data. This must be an \code{Learner} (\code{mlr3}) or \code{train} (\code{caret}) object.}

\item{data}{The data used for computing FMEs, must be data.frame or data.table.}

\item{target}{A string specifying the model's target variable.}

\item{feature}{A character vector of the names of the feature variables affected by the step.
For numerical steps, this must have length 1 or 2.
For categorical steps, this must have length 1.}

\item{step.size}{A numeric vector of the step lengths in the features affected by the step.
For numerical steps, this must have length 1 or 2.
For categorical steps, this is the name of the reference category.}

\item{ep.method}{String specifying the method used for extrapolation detection. One of \code{"none"} or \code{"envelope"}. Defaults to \code{"none"}.}

\item{compute.nlm}{Compute NLMs for FMEs for numerical steps. Defaults to \code{FALSE}.}

\item{nlm.intervals}{Number of intervals for computing NLMs. Results in longer computing time but more accurate approximation of NLMs. Defaults to \code{1}.}
}
\value{
\code{FME} Object with FMEs computed.
}
\description{
This is a wrapper function for \code{FME$new(...)$compute()}.
It computes forward marginal effects (FMEs) for a specified change in feature values.
}
\examples{
# Train a model:

library(mlr3verse)
library(ranger)
data(bikes, package = "fmeffects")
forest = lrn("regr.ranger")$train(as_task_regr(x = bikes, id = "bikes", target = "count"))

# Compute FMEs:
effects = fme(model = forest, data = bikes, target = "count", feature = "temp",
              step.size = 1, ep.method = "envelope")

# Analyze results:
summary(effects)
plot(effects)

# Extract results:
effects$results
}
\references{
Scholbeck, C. A., Casalicchio, G., Molnar, C., Bischl, B., & Heumann, C. (2022). Marginal Effects for Non-Linear Prediction Functions.
}
