% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_normal.R
\name{kernel_normal}
\alias{kernel_normal}
\alias{kernel_normal_reflective}
\title{Gaussian Transition Kernel}
\usage{
kernel_normal(mu = 0, scale = 1, fixed = FALSE, scheme = "joint")

kernel_normal_reflective(
  mu = 0,
  scale = 1,
  lb = -.Machine$double.xmax,
  ub = .Machine$double.xmax,
  fixed = FALSE,
  scheme = "joint"
)
}
\arguments{
\item{mu, scale}{Either a numeric vector or a scalar. Proposal mean and scale.
If scalar, values are recycled to match the number of parameters in the
objective function.}

\item{fixed, scheme}{For multivariate functions, sets the update plan.
See \code{\link[=plan_update_sequence]{plan_update_sequence()}}.}

\item{lb, ub}{Either a numeric vector or a scalar. Lower and upper bounds for
bounded kernels. When of length 1, the values are recycled to match the number
of parameters in the objective function.}
}
\value{
An object of class \link{fmcmc_kernel}. \code{fmcmc_kernel} objects are intended
to be used with the \code{\link[=MCMC]{MCMC()}} function.
}
\description{
Gaussian Transition Kernel
}
\details{
The \code{kernel_normal} function provides the canonical normal kernel
with symmetric transition probabilities.

The \code{kernel_normal_reflective} implements the normal kernel with reflective
boundaries. Lower and upper bounds are treated using reflecting boundaries, this is,
if the proposed \eqn{\theta'} is greater than the \code{ub}, then \eqn{\theta' - ub}
is subtracted from \eqn{ub}. At the same time, if it is less than \code{lb}, then
\eqn{lb - \theta'} is added to \code{lb} iterating until \eqn{\theta} is within
\code{[lb, ub]}.

In this case, the transition probability is symmetric (just like the normal
kernel).
}
\examples{
# Normal kernel with a small scale (sd) of 0.05
kern <- kernel_normal(scale = 0.05)

# Using boundaries for the second parameter of a two parameter chain
# to have values in [0, 100].
kern <- kernel_normal_reflective(
  ub = c(.Machine$double.xmax, 100),
  lb = c(-.Machine$double.xmax, 0)
  )
}
\seealso{
Other kernels: 
\code{\link{kernel_adapt}()},
\code{\link{kernel_mirror}},
\code{\link{kernel_new}()},
\code{\link{kernel_ram}()},
\code{\link{kernel_unif}()}
}
\concept{kernels}
