% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interest-rate-classes.R
\name{InterestRate}
\alias{InterestRate}
\title{InterestRate class}
\usage{
InterestRate(value, compounding, day_basis)
}
\arguments{
\item{value}{a numeric vector containing interest rate values (as decimals).}

\item{compounding}{a numeric vector representing the \link{compounding} frequency.}

\item{day_basis}{a character vector representing the day basis associated
with the interest rate (see \code{\link[fmdates:year_frac]{fmdates::year_frac()}})}
}
\value{
a vectorised \code{InterestRate} object
}
\description{
The \code{InterestRate} class is designed to represent interest rates. Checks
whether: the \code{day_basis} is valid; and the \code{compounding} is valid. An error
is thrown if any of these are not true. The elements of each argument are
recycled such that each resulting vectors have equivalent lengths.
}
\examples{
library("lubridate")
InterestRate(c(0.04, 0.05), c(2, 4), 'act/365')
rate <- InterestRate(0.04, 2, 'act/365')
as_DiscountFactor(rate, ymd(20140101), ymd(20150101))
as_InterestRate(rate, compounding = 4, day_basis = 'act/365')
}
