% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_folder.R
\name{export_folder}
\alias{export_folder}
\title{Upload a folder from the local system to cloud}
\usage{
export_folder(localfolder, bucketpath, pattern = "*", overwrite = TRUE,
  data_source = flyio_get_datasource(),
  bucket = flyio_get_bucket(data_source), show_progress = FALSE, ...)
}
\arguments{
\item{localfolder}{path of the folder in which all the files are to be uploaded}

\item{bucketpath}{path of the folder in which the files are to be uploaded}

\item{pattern}{pattern of the file names in the folder to be uploaded}

\item{overwrite}{if files need to be overwritten (if already present)}

\item{data_source}{the name of the data source, if not set globally. can be gcs or s3}

\item{bucket}{the name of the bucket, if not set globally}

\item{show_progress}{logical. Shows progress of the upload operation.}

\item{...}{other parameters for gcs/s3 upload}
}
\value{
the filename and path of the file in the bucket
}
\description{
Write a local folder to the cloud, S3 or GCS
}
\examples{
\dontrun{
flyio_set_datasource("gcs")
flyio_set_bucket("your-bucket-name")
export_folder("folder-local/", "folder-on-cloud/")
}
}
