% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bracket.r
\name{bracket}
\alias{bracket}
\alias{[,float32-method}
\alias{[<-,float32-method}
\title{Extract}
\usage{
\S4method{[}{float32}(x, i, j, drop = TRUE)

\S4method{[}{float32}(x, i, j, ...) <- value
}
\arguments{
\item{x}{A float vector/matrix.}

\item{i, j, ...}{The indices.  Most combinations of integer/double/logical values will be
treated the same as R does. One major difference is that \code{NA} values
will not be tolerated.}

\item{drop}{Logical. If TRUE, single column matrices will be treated as one-dimensional
vectors.}

\item{value}{The replacement value.}
}
\value{
A float vector/matrix.
}
\description{
Extract subsets of a float vector/matrix.
}
\examples{
\dontrun{
library(float)

s = flrunif(10, 3)
s[, -1]
s[c(1, 3, 5, 7), 1:2]
}

}
