% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossprod.r
\docType{methods}
\name{crossprod}
\alias{crossprod}
\alias{crossprod,Mat-method}
\alias{tcrossprod,Mat-method}
\title{crossprod}
\usage{
\S4method{crossprod}{Mat}(x, y = NULL)

\S4method{tcrossprod}{Mat}(x, y = NULL)
}
\arguments{
\item{x}{A float vector/matrix.}

\item{y}{Either \code{NULL}, or a numeric/float matrix.}
}
\value{
A float matrix (unless \code{y} is numeric; see details section).
}
\description{
Croddproducts.
}
\details{
If \code{y} is a numeric matrix, then \code{x} will be promoted to a numeric
matrix, and the return will therefore be numeric (not float).
}
\examples{
library(float)

s = flrunif(10, 3)
crossprod(s)
tcrossprod(s)

}

