% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill-gaps.R
\name{fill_gaps}
\alias{fill_gaps}
\title{Fill gaps in clusters of cells}
\usage{
fill_gaps(x, max_gap = 15)
}
\arguments{
\item{x}{SpatRaster}

\item{max_gap}{numeric. Gaps with an area smaller than \code{max_gap} are filled (see details for more information about the unit of this value).}
}
\value{
SpatRaster
}
\description{
The function fills gaps with an area smaller than \code{max_gap}. A gap is considered a patch of \code{NA} cells that lies within a cluster of cells with the same value. The implementation of the function relies on the function \code{nngeo::st_remove_holes()}.
}
\details{
\code{max_gap} has the same unit as the resolution of \code{x}. For example, with a SpatRaster in Mollweide (\code{EPSG:54009}) and a resolution of 1 km², \code{max_gap} is interpreted in km².
}
\examples{
nr <- nc <- 8
r <- terra::rast(nrows = nr, ncols = nc, ext = c(0, nc, 0, nr), crs = "epsg:25831")
terra::values(r) <- c(
  NA, NA, NA, NA, 1, 1, 1, NA,
  NA, 2, 2, 2, NA, NA, 1, NA,
  NA, 2, NA, 2, 2, NA, 1, 1,
  NA, 2, NA, NA, 2, 2, NA, NA,
  NA, 2, 2, 2, 2, NA, NA, NA,
  NA, NA, NA, NA, NA, NA, NA, NA,
  NA, NA, NA, NA, NA, NA, NA, NA,
  NA, NA, NA, NA, NA, NA, NA, NA
)
terra::plot(r)
gaps_filled <- fill_gaps(r)
terra::plot(gaps_filled)
}
