% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borders.R
\name{hline_bottom}
\alias{hline_bottom}
\title{Set bottom horizontal border}
\usage{
hline_bottom(x, j = NULL, border = NULL, part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{j}{columns selection}

\item{border}{border properties defined by a call to \code{\link[=fp_border]{fp_border()}}}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
The function is applying an horizontal border to the
bottom of one or all parts of a flextable. The line is the
bottom border of selected parts.
}
\examples{
library(officer)
big_border <- fp_border(color = "orange", width = 3)

ft <- flextable(head(iris))
ft <- border_remove(x = ft)

# add/replace horizontal border on bottom
ft <- hline_bottom(ft, part = "body", border = big_border)
ft
}
\seealso{
Other borders management: 
\code{\link{border_inner}()},
\code{\link{border_inner_h}()},
\code{\link{border_inner_v}()},
\code{\link{border_outer}()},
\code{\link{border_remove}()},
\code{\link{hline}()},
\code{\link{hline_top}()},
\code{\link{surround}()},
\code{\link{vline}()},
\code{\link{vline_left}()},
\code{\link{vline_right}()}
}
\concept{borders management}
