% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.flexsurvrtrunc.R
\name{summary.flexsurvrtrunc}
\alias{summary.flexsurvrtrunc}
\title{Summarise quantities of interest from fitted flexsurvrtrunc models}
\usage{
\method{summary}{flexsurvrtrunc}(
  object,
  type = "survival",
  fn = NULL,
  t = NULL,
  quantiles = 0.5,
  ci = TRUE,
  se = FALSE,
  B = 1000,
  cl = 0.95,
  ...
)
}
\arguments{
\item{object}{Output from \code{\link{flexsurvreg}} or
\code{\link{flexsurvspline}}, representing a fitted survival model object.}

\item{type}{\code{"survival"} for survival probabilities.

\code{"cumhaz"} for cumulative hazards.

\code{"hazard"} for hazards.

\code{"rmst"} for restricted mean survival.

\code{"mean"} for mean survival.

\code{"median"} for median survival (alternative to \code{type="quantile"} with \code{quantiles=0.5}).

\code{"quantile"} for quantiles of the survival time distribution.

 Ignored if \code{"fn"} is specified.}

\item{fn}{Custom function of the parameters to summarise against time.
This has optional first argument \code{t} representing time, and any remaining
arguments must be parameters of the distribution.  It should return a
vector of the same length as \code{t}.}

\item{t}{Times to calculate fitted values for. By default, these are the
sorted unique observation (including censoring) times in the data - for
left-truncated datasets these are the "stop" times.}

\item{quantiles}{If \code{type="quantile"}, this specifies the quantiles of the survival time distribution to return estimates for.}

\item{ci}{Set to \code{FALSE} to omit confidence intervals.}

\item{se}{Set to \code{TRUE} to include standard errors.}

\item{B}{Number of simulations from the normal asymptotic distribution of
the estimates used to calculate confidence intervals or standard errors.
Decrease for greater
speed at the expense of accuracy, or set \code{B=0} to turn off calculation
of CIs and SEs.}

\item{cl}{Width of symmetric confidence intervals, relative to 1.}

\item{...}{Further arguments passed to or from other methods.  Currently
unused.}
}
\description{
This function extracts quantities of interest from the untruncated 
version of a model with individual-specific right truncation points 
fitted by \code{\link{flexsurvrtrunc}}.  Note that covariates are
currently not supported by \code{\link{flexsurvrtrunc}}.
}
