% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.flexsurvmix.R
\name{p_flexsurvmix}
\alias{p_flexsurvmix}
\title{Transition probabilities from a flexsurvmix model}
\usage{
p_flexsurvmix(x, newdata = NULL, startname = "start", t = 1, B = NULL)
}
\arguments{
\item{x}{Fitted model object returned from \code{\link{flexsurvmix}}.}

\item{newdata}{Data frame or list of covariate values.   If omitted for a
model with covariates, a default is used, defined by all combinations of
factors if the only covariates in the model are factors, or all covariate
values of zero if there are any non-factor covariates in the model.}

\item{startname}{Name of the state where individuals start. This considers
the model as a multi-state model where people start in this state, and may
transition to one of the competing events.}

\item{t}{Vector of times \code{t} to calculate the probabilities of
transition by.}

\item{B}{Number of simulations to use to compute 95\% confidence intervals,
based on the asymptotic multivariate normal distribution of the basic
parameter estimates.  If \code{B=NULL} then intervals are not computed.}
}
\value{
A data frame with transition probabilities by time, covariate value
  and destination state.
}
\description{
These quantities are variously known as transition probabilities, or state
occupancy probabilities, or values of the "cumulative incidence" function,
or values of the "subdistribution" function. They are the probabilities that
an individual has experienced an event of a particular kind by time
\code{t}.
}
\details{
Note that "cumulative incidence" is a misnomer, as "incidence" typically
means a hazard, and the quantities computed here are not cumulative hazards,
but probabilities.
}
