% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_growth_curves.R
\name{fn_lin_pl_lin2}
\alias{fn_lin_pl_lin2}
\title{Linear plateau linear with constrains}
\usage{
fn_lin_pl_lin2(t, t1, t2, dt, k, beta)
}
\arguments{
\item{t}{Numeric. The time value.}

\item{t1}{Numeric. The lower threshold time.}

\item{t2}{Numeric. The upper threshold time before plateau.}

\item{dt}{Numeric. dt = t3 - t2.}

\item{k}{Numeric. The maximum value of the function.}

\item{beta}{Numeric. Slope of the linear decay.}
}
\value{
A numeric value based on the linear plateau linear model.
}
\description{
Linear plateau linear with constrains
}
\details{
\if{html}{
\deqn{
f(t; t_1, t_2, dt, k, \beta) =
\begin{cases}
0 & \text{if } t < t_1 \\
\dfrac{k}{t_2 - t_1} \cdot (t - t_1) & \text{if } t_1 \leq t \leq t_2 \\
k & \text{if } t_2 \leq t \leq (t_2 + dt) \\
k + \beta \cdot (t - (t_2 + dt)) & \text{if } t > (t_2 + dt)
\end{cases}
}
}
}
\examples{
library(flexFitR)
plot_fn(
  fn = "fn_lin_pl_lin2",
  params = c(t1 = 38.7, t2 = 62, dt = 28, k = 0.32, beta = -0.01),
  interval = c(0, 108),
  n_points = 2000,
  auc_label_size = 3
)
}
