% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-unbump-version.R, R/unbump-version.R
\name{unbump_version}
\alias{unbump_version}
\alias{unbump_version_impl}
\title{Undoes bumping the package version}
\usage{
unbump_version()
}
\value{
\code{NULL}, invisibly. This function is called for its side effects.

None
}
\description{
This undoes the effect of a \code{\link[=bump_version]{bump_version()}} call, with a safety check.
}
\examples{
# Create mock package in a temporary directory.
# Set open to TRUE if you want to play in the mock package.
with_demo_project({
  # Use functions as if inside the newly created package project.
  # (Or go and actually run code inside the newly created package project!)
  # Add a new R file.
  usethis::use_r("cool-function", open = FALSE)
  # Pretend we added useful code inside it.
  # Track the new R file with Git.
  gert::git_add("R/cool-function.R")
  gert::git_commit("- Add cool function.")
  # Bump version with fledge.
  fledge::bump_version()
  # Oh no, we forgot to also add the awesome function for that version!
  # UNBUMP
  fledge::unbump_version()
  # Add a new R file.
  usethis::use_r("awesome-function", open = FALSE)
  # Pretend we added awesome code inside it.
  # Track the new R file with Git.
  gert::git_add("R/awesome-function.R")
  gert::git_commit("- Add awesome function.")
  # Bump version with fledge.
  fledge::bump_version()
  #'
})
}
\seealso{
bump_version
}
