% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-finalize-version.R, R/finalize-version.R
\name{finalize_version}
\alias{finalize_version}
\alias{finalize_version_impl}
\title{Finalize package version}
\usage{
finalize_version(push = FALSE)
}
\arguments{
\item{push}{If \code{TRUE}, push the created tag.}
}
\value{
None
}
\description{
Calls the following functions:

\enumerate{
\item \code{\link[=commit_version]{commit_version()}}
\item \code{\link[=tag_version]{tag_version()}}, setting \code{force = TRUE} if and only if \code{commit_version()}
amended a commit.
\item Force-pushes the created tag to the \code{"origin"} remote, if \code{push = TRUE}.
}
}
\examples{
# Create mock package in a temporary directory.
# Set open to TRUE if you want to play in the mock package.
with_demo_project({
  # Use functions as if inside the newly created package project.
  # (Or go and actually run code inside the newly created package project!)
  # Add a new R file.
  usethis::use_r("cool-function", open = FALSE)
  # Pretend we added useful code inside it.
  # Track the new R file with Git.
  gert::git_add("R/cool-function.R")
  gert::git_commit("- Add cool function.")
  # Bump version with fledge.
  fledge::bump_version()
  # Edit news by hand
  # ...
  # Once done
  fledge::finalize_version()
})
}
