% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_ice.R
\name{light_ice}
\alias{light_ice}
\alias{light_ice.default}
\alias{light_ice.flashlight}
\alias{light_ice.multiflashlight}
\title{Individual Conditional Expectation (ICE)}
\usage{
light_ice(x, ...)

\method{light_ice}{default}(x, ...)

\method{light_ice}{flashlight}(x, v = NULL, data = x$data, by = x$by,
  evaluate_at = NULL, breaks = NULL, grid = NULL, n_bins = 27,
  cut_type = c("equal", "quantile"), indices = NULL, n_max = 20,
  seed = NULL, use_linkinv = TRUE, center = FALSE,
  center_at = c("first", "middle", "last"), value_name = "value",
  label_name = "label", id_name = "id", ...)

\method{light_ice}{multiflashlight}(x, ...)
}
\arguments{
\item{x}{An object of class \code{flashlight} or \code{multiflashlight}.}

\item{...}{Further arguments passed to or from other methods.}

\item{v}{The variable to be profiled.}

\item{data}{An optional \code{data.frame}.}

\item{by}{An optional vector of column names used to additionally group the results.}

\item{evaluate_at}{Vector with values of \code{v} used to evaluate the profile.}

\item{breaks}{Instead of \code{evaluate_at} (and \code{grid}), cut points for \code{x} can be provided. From them, \code{evaluate_at} values are calculates as averages.}

\item{grid}{A \code{data.frame} with grid values as those generated by \code{expand.grid}.}

\item{n_bins}{Maximum number of unique values to evaluate for numeric \code{v}. Only used in neither \code{grid} nor \code{evaluate_at} is specified.}

\item{cut_type}{For the default "equal", bins of equal width are created for \code{v} by \code{pretty}. Choose "quantile" to create quantile bins. Only used in neither \code{grid} nor \code{evaluate_at} is specified.}

\item{indices}{A vector of row numbers to consider.}

\item{n_max}{If \code{indices} is not given, maximum number of rows to consider. Will be randomly picked from \code{data} if necessary.}

\item{seed}{An integer random seed.}

\item{use_linkinv}{Should retransformation function be applied? Default is TRUE.}

\item{center}{Should curves be centered? Default is FALSE. Note that centering will be done at the first evaluation point and within "by" group. It will work also for a \code{grid} with multiple columns.}

\item{center_at}{If \code{center = TRUE}: Which evaluation point to center at. One of "first", "middle", or "last".}

\item{value_name}{Column name in resulting \code{data} containing the profile value. Defaults to "value".}

\item{label_name}{Column name in resulting \code{data} containing the label of the flashlight. Defaults to "label".}

\item{id_name}{Column name in resulting \code{data} containing the row id of the profile. Defaults to "id_name".}
}
\value{
An object of class \code{light_ice}, \code{light} (and a list) with the following elements.
\itemize{
  \item \code{data} A tibble containing the results. Can be used to build fully customized visualizations. Its column names are specified by all other items in this list.
  \item \code{by} Same as input \code{by}.
  \item \code{v} The variable(s) evaluated.
  @item \code{center} Flag if ICE curves are centered.
  \item \code{value_name} Same as input \code{value_name}.
  \item \code{label_name} Same as input \code{label_name}.
  \item \code{id_name} Same as input \code{id_name}.
}
}
\description{
Generates Individual Conditional Expectation (ICE) profiles. An ICE profile shows how the prediction of an observation changes if one or multiple variables are systematically changed across its ranges, holding all other values fixed [1]. The curves can be centered in order to increase visibility of interaction effects. Centering is done within subgroups specified by "by".
}
\details{
There are two ways to specify the variable(s) to be profiled. The first option is to pass the variable name via \code{v} and an optional vector with evaluation points \code{evaluate_at} (or \code{breaks}). This works for dependence on a single variable. The second option is much more general: You can specify any \code{grid} as a \code{data.frame} with one or more columns. It can e.g. be generated by a call to \code{expand.grid}. Currently, there is no option to pass more than one variable name without such grid. The minimum required elements in the (multi-)flashlight are "predict_function", "model", "linkinv" and "data", where the latest can be passed on the fly. Which rows in \code{data} are profiled? This is specified by \code{indices}. If not given and \code{n_max} is smaller than the number of rows in \code{data}, then row indices will be sampled randomly from \code{data}. If the same rows should be used for all flashlights in a multiflashlight, there are two options: Either pass a \code{seed} (with potentially undesired consequences for subsequent code) or a vector of indices used to select rows. In both cases, \code{data} should be the same for all flashlights considered.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method not implemented yet.

\item \code{flashlight}: ICE profiles for a flashlight object.

\item \code{multiflashlight}: ICE profiles for a multiflashlight object.
}}

\examples{
fit_full <- lm(Sepal.Length ~ ., data = iris)
fit_part <- lm(Sepal.Length ~ Petal.Length, data = iris)
mod_full <- flashlight(model = fit_full, label = "full", data = iris, y = "Sepal.Length")
mod_part <- flashlight(model = fit_part, label = "part", data = iris, y = "Sepal.Length")
mods <- multiflashlight(list(mod_full, mod_part))
grid <- expand.grid(Species = levels(iris$Species), Petal.Length = 2:4)
light_ice(mod_full, v = "Species")
light_ice(mod_full, v = "Species", indices = (1:15) * 10)
light_ice(mod_full, v = "Species", evaluate_at = levels(iris$Species))
light_ice(mod_full, grid = grid, data = iris[1,])$data
light_ice(mods, v = "Species", indices = (1:15) * 10)
light_ice(mods, v = "Species", indices = (1:15) * 10, center = TRUE)
light_ice(mods, v = "Petal.Width", n_bins = 5)
light_ice(mods, v = "Petal.Width", by = "Species", n_bins = 5)
light_ice(mods, v = "Petal.Width", by = "Species",
  id_name = "profile", value_name = "val", label_name = "lab")
}
\references{
[1] Goldstein, A. et al. (2015). Peeking inside the black box: Visualizing statistical learning with plots of individual conditional expectation. Journal of Computational and Graphical Statistics, 24:1 <doi.org/10.1080/10618600.2014.907095>.
}
\seealso{
\code{\link{light_profile}}, \code{\link{plot.light_ice}}.
}
