% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBarrierTree3D.R
\name{plotBarrierTree3D}
\alias{plotBarrierTree3D}
\title{Plot Barrier Tree in 3D}
\usage{
plotBarrierTree3D(feat.object, control)
}
\arguments{
\item{feat.object}{[\code{\link{FeatureObject}}]\cr
A feature object as created by \code{\link{createFeatureObject}}.}

\item{control}{[\code{list}]\cr
A \code{list}, which stores additional control arguments.
For further information, see details.}
}
\value{
[\code{plot}].\cr
  A 3D-surface plot, visualizing the barrier tree of this cell mapping.
}
\description{
Creates a 3D surface plot containing the barrier tree of this cell mapping.
}
\details{
Possible \code{control} arguments are:
  \itemize{
    \item{Computation of Cell Mapping}: \itemize{
      \item{\code{gcm.approach}}: Which approach should be used when
      computing the representatives of a cell. The default is \code{"min"},
      i.e. the observation with the best (minimum) value within per cell.
      \item{\code{gcm.cf_power}}: Theoretically, we need to compute the
      canonical form to the power of infinity. However, we use this value
      as approximation of infinity. The default is \code{256}.
    }
    \item{Plot Control}: \itemize{
      \item{\code{bt.margin}}: Margins of the plot as used by
      \code{par("mar")}. The default is \code{c(0.5, 1, 0, 0)}.
      \item{\code{bt.color_surface}}: Color of the surface of the
      perspective plot. The default is \code{"lightgrey"}.
      \item{\code{bt.color_branches}}: Color used for the branches of the
      barrier tree. Per default there will be one color per level.
      \item{\code{bt.persp_border}}: Color of the lines / borders around
      each facet of the perspective plot. The default is \code{"grey"}.
      \item{\code{bt.persp_shade}}: A ratio defining the shade of the
      surface. The default is \code{0.35}.
      \item{\code{bt.persp_{theta, phi}}}: Angles (in degree) defining the
      viewing direction of the perspective plot. \code{theta} corresponds to
      the azimuthal direction (default: \code{330}) and \code{phi} to the
      colatitude (default: \code{15}).
      \item{\code{bt.persp_{xlab, ylab, zlab}}}: Labels of the x-, y- and z-
      axis. The defaults are \code{expression(x[1])},
      \code{expression(x[2])} and \code{expression(f(x[1], x[2]))}
      \item{\code{bt.persp_ticktype}}: Should the values of each dimension
      be shown in detail (\code{"detailed"}) or just via \code{"simple"}
      arrows in direction of increasement along the axes? The default is
      \code{"detailed"}.
      \item{\code{bt.col_root}}: Color of the root symbol. The default is
      \code{"red"}.
      \item{\code{bt.pch_root}}: Symbol used for plotting the root.
      The default is \code{17} (filled triangle).
      \item{\code{bt.pch_breakpoint}}: Symbol used for plotting a
      breakpoint. The default is \code{5} (non-filled diamond).
      \item{\code{bt.pch_basin}}: Symbol used for plotting the leaf (i.e. a
      basin) of the barrier tree. The default is \code{19} (filled circle).
      \item{\code{bt.lwd}}: Width of the lines used for plotting the
      branches of a barrier tree. The default is \code{2}.
    }
  }
}
\examples{
# create a feature object
X = createInitialSample(n.obs = 900, dim = 2)
f = smoof::makeAckleyFunction(dimensions = 2)
y = apply(X, 1, f)
feat.object = createFeatureObject(X = X, y = y, fun = f, blocks = c(4, 6))

# plot the corresponing barrier tree
plotBarrierTree3D(feat.object)
}

