% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afltables_player.R
\name{get_afltables_stats}
\alias{get_afltables_stats}
\title{Return afltables match stats}
\usage{
get_afltables_stats(start_date = "1897-01-01", end_date = Sys.Date())
}
\arguments{
\item{start_date}{character string for start date return to URLs from, in "dmy" or "ymd" format}

\item{end_date}{optional, character string for end date to return URLS, in "dmy" or "ymd" format}
}
\value{
a data table containing player stats for each game between start date and end date
}
\description{
\code{get_afltables_stats} returns a data frame containing match stats for each game within the specified date range
}
\details{
This function returns a data frame containing match stats for each game within the specified date range. The data from contains all stats on afltables match pages and returns 1 row per player.

The data for this function is hosted on github to avoid extensive scraping of historical data from afltables.com. This will be updated regularly.
}
\examples{
#
\donttest{
# Gets all data
get_afltables_stats()
# Specify a date range
get_afltables_stats("01/01/2018", end_date = "01/04/2018")
}
}
