% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.psFit.R
\name{confint.psFit}
\alias{confint.psFit}
\title{S3 confint method for objects of class psFit}
\usage{
\method{confint}{psFit}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{an object of class \code{psFit}---see fitDist for more details}

\item{parm}{added for compatibility. Should be left empty as it is ignored.}

\item{level}{the confidence level required---restricted to [0.75, 1)}

\item{...}{in theory other parameters to be passed to \code{confint}, but in
reality passed as extra parameters to the internal function \code{plZIZ}.}
}
\value{
if the zeta model is used (i.e \code{object} comes from a call to
  \code{\link{fitDist}}),then a list with two items: \code{wald} and
  \code{prof} containing the Wald and profile likelihood confidence intervals
  respectively for the shape parameter of the fitted zeta distribution is
  returned. In general these should be relatively close to each other.
  **NOTE** These values are for the \pkg{VGAM} parameterisation of the Zeta
  distribution which uses \eqn{s^\prime = s - 1}{s' = s - 1}. This means they
  can be used without alteration in \code{\link[VGAM]{dzeta}}. If a
  zero-inflated zeta model is used (i.e. \code{object} comes from a call to
  \code{\link{fitZIDist}}) then list of a confidence regions is returned with
  and element for each value of \code{level}. The confidence regions are
  \code{data.frame}s with variables \code{pi} and \code{shape} which can be
  used with \code{\link[graphics]{lines}} or \code{\link[graphics]{polygon}}
  to draw a the confidence region.
}
\description{
S3 confint method for objects of class psFit
}
\details{
NOTE: the method for ZIZ model is a little computationally intensive
and possibly (almost certainly) unstable.
}
\examples{
data(Psurveys)
roux = Psurveys$roux
fit = fitDist(roux)
confint(fit)

\dontrun{
fit.zi = fitZIDist(roux)
cr = confint(fit.zi, level = c(0.80, 0.95))
plot(cr[["0.95"]], type = "l")
polygon(cr[["0.8"]])
}

}
