% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status.R
\docType{data}
\name{status}
\alias{status}
\title{Status}
\format{
Data frame containing four columns:
\tabular{ll}{
  \code{status}             \tab status code\cr
  \code{status_name}        \tab status name\cr
  \code{status_description} \tab short name\cr
  \code{alternate}          \tab unit multiplier
}
}
\source{
FAO (2024).
Global Production.
Fisheries and Aquaculture Division. Rome.

\url{https://www.fao.org/fishery/en/collection/global_production}
}
\usage{
status
}
\description{
Status of data entries, defined by FAO (2024).
}
\details{
This data frame contains the full set of 16 data records from the FishStat
\emph{Symbols} data table. Column names have been simplified to facilitate
quick exploration and plotting in R.
}
\examples{
head(status, 3)

# Aquaculture data entries
# 80\% have official status, 17\% are estimated, and 3\% are negligible
100 * proportions(table(aquaculture$status))

# Capture data entries
# 94\% have official status, 3\% are estimated, and 3\% are negligible
100 * proportions(table(capture$status))

# Examine one status definition
print.simple.list(status[status$status=="N",])
}
\seealso{
\code{\link{aquaculture}} and \code{\link{capture}} data are also
available in a combined \code{\link{production}} format.

\code{\link{area}}, \code{\link{country}}, \code{\link{environment}},
\code{\link{measure}}, \code{\link{source}}, \code{\link{species}}, and
\code{\link{status}} are lookup tables.

\code{\link{fishstat-package}} gives an overview of the package.
}
