#' Morphological data of juvenile fish
#'
#' A dataset containing morphological data for juveniles of a migratory
#' fish species. It matches with the "juvenile_growths" dataset
#'
#' @format A dataset containing 496 rows and 7 variables
#' \describe{
#' \item{fish_id}{a unique identifier for each fish}
#' \item{site}{one of two collection sites}
#' \item{day}{day that the fish was collected on}
#' \item{month}{month that the fish was collected on}
#' \item{standard_length}{standard length of the fish (distance from
#' posterior to caudal peduncle)}
#' \item{body_depth}{body depth of the fish at its maximum point}
#' \item{otolith_id}{unique identifier for the fishes otolith}
#' }
#' @usage data(juvenile_morphologies)
#' @example {
#' data(juvenile_morphologies)
#' }

"juvenile_morphologies"
