% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FireSale.R
\name{FireSale}
\alias{FireSale}
\title{A FireSale plugin}
\description{
A FireSale plugin

A FireSale plugin
}
\details{
The class encapsulates the firesale functionality into a fiery plugin. You
use it by creating and attaching it to a fiery server object.
}
\section{Initialization}{

A new 'FireSale'-object is initialized using the \code{new()} method on the
generator (shown here with the environment driver):

\strong{Usage}
\tabular{l}{
\code{datastore <- FireSale$new(storr::driver_environment())}
}
}

\section{Fiery plugin}{

This class is mainly intended to be used as a fiery plugin, by attaching it
to a fiery server object. It works by providing a \code{datastore} element (name
can be modified with the \code{arg_name} argument during initialization) in the
\code{arg_list} argument to \code{request} handlers. The object contains two elements,
\code{global} and \code{session}. The first contains data shared by all sessions, while
the latter is scoped to the current session. Both of these elements are
list-like, but in reality are interfaces to the underlying data store
}

\examples{
# Create a datastore object
ds <- FireSale$new(storr::driver_environment())

\dontshow{if (requireNamespace("fiery", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Attach it to a fiery server
app <- fiery::Fire$new()

app$attach(ds)
\dontshow{\}) # examplesIf}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{The name of the plugin}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FireSale-new}{\code{FireSale$new()}}
\item \href{#method-FireSale-format}{\code{FireSale$format()}}
\item \href{#method-FireSale-get_mall}{\code{FireSale$get_mall()}}
\item \href{#method-FireSale-shiny_mall}{\code{FireSale$shiny_mall()}}
\item \href{#method-FireSale-on_attach}{\code{FireSale$on_attach()}}
\item \href{#method-FireSale-clone}{\code{FireSale$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FireSale-new"></a>}}
\if{latex}{\out{\hypertarget{method-FireSale-new}{}}}
\subsection{Method \code{new()}}{
Initializes a new FireSale object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FireSale$new(
  driver,
  arg_name = "datastore",
  gc_interval = 3600,
  max_age = gc_interval
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{driver}}{A storr driver to use for the backend}

\item{\code{arg_name}}{A string giving the name under which the data store
should appear in the \code{arg_list} argument}

\item{\code{gc_interval}}{The interval with which the backend should be garbage
collected. The value is indicative and a garbage collection may happen
at longer intervals}

\item{\code{max_age}}{The maximum age in second an ID can be left unused before
being purged. The value is indicative and a stale ID store may linger
longer than this}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FireSale-format"></a>}}
\if{latex}{\out{\hypertarget{method-FireSale-format}{}}}
\subsection{Method \code{format()}}{
Textual representation of the plugin
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FireSale$format(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FireSale-get_mall"></a>}}
\if{latex}{\out{\hypertarget{method-FireSale-get_mall}{}}}
\subsection{Method \code{get_mall()}}{
Create a mall (a collection of storefronts) containing a
global and a session-specific storefront
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FireSale$get_mall(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The session id of the current session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FireSale-shiny_mall"></a>}}
\if{latex}{\out{\hypertarget{method-FireSale-shiny_mall}{}}}
\subsection{Method \code{shiny_mall()}}{
Create a mall from a shiny session object. If the shiny app
has been launched from a plumber2 server the session id is automatically
resolved. If not, you must provide an id function that extracts the
session id from a \link[reqres:Request]{reqres::Request} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FireSale$shiny_mall(session, id_fun = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A ShinySession object}

\item{\code{id_fun}}{A function that can extract the session ID from a \code{Request}
object. This is handled automatically for shiny apps launched from a
plumber2 server. The default id function for fiery servers is constructed
with \code{fiery::session_id_cookie()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FireSale-on_attach"></a>}}
\if{latex}{\out{\hypertarget{method-FireSale-on_attach}{}}}
\subsection{Method \code{on_attach()}}{
Method for use by \code{fiery} when attached as a plugin. Should
not be called directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FireSale$on_attach(app, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{app}}{The fiery server object}

\item{\code{...}}{Ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FireSale-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FireSale-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FireSale$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
