% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_comparison_concept_network.R
\name{fst_cn_get_unique}
\alias{fst_cn_get_unique}
\title{Concept Network- Get Unique Nodes}
\usage{
fst_cn_get_unique(table1, table2, ...)
}
\arguments{
\item{table1}{The first table.}

\item{table2}{The second table.}

\item{...}{Any other tables you want to include.}
}
\value{
Dataframe of words and whether word is unique or not.
}
\description{
Takes at least two tables of nodes and pagerank (output of `fst_cn_nodes()`)
and finds nodes unique to one table.
}
\examples{
cb <- conllu_cb_bullying_iso
pos_filter = c("NOUN", "VERB", "ADJ", "ADV")
e1 <- fst_cn_edges(cb, "lyödä", pos_filter = pos_filter)
e2 <- fst_cn_edges(cb, "lyöminen", pos_filter = pos_filter)
n1 <- fst_cn_nodes(cb, e1)
n2 <- fst_cn_nodes(cb, e2)
fst_cn_get_unique(n1, n2)
}
