% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{transmission_capacity_intraday_market_SE1_to_FI}
\alias{transmission_capacity_intraday_market_SE1_to_FI}
\title{Transmission capacity for intraday market from Northern Sweden to Finland (SE1-FI)}
\usage{
transmission_capacity_intraday_market_SE1_to_FI(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains transmission capacity for
intraday market from Northern Sweden to Finland (SE1-FI). For intraday
market capacity is given as free capacity after dayahead market.
Capacity is published once a day and not updated.
}
\description{
Check https://data.fingrid.fi/en/dataset/transmission-capacity-to-be-given-to-intraday-market-se1-fi
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- transmission_capacity_intraday_market_SE1_to_FI(start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
