% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{intraday_transmission_capacity_RUS_to_FI}
\alias{intraday_transmission_capacity_RUS_to_FI}
\title{Intraday transmission capacity RUS-FI}
\usage{
intraday_transmission_capacity_RUS_to_FI(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains the capacity given to intraday
market means transfer capacity after day-ahead trade from Russia to
Finland. The intraday capacity between Finland and Russia is updated
once a day.
}
\description{
Check https://data.fingrid.fi/en/dataset/intraday-transmission-capacity-rus-fi
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- intraday_transmission_capacity_RUS_to_FI(start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
