% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{get_data}
\alias{get_data}
\title{Main logic forming the API call.}
\usage{
get_data(api_number = NA, start_time = NA, end_time = NA, user_key = NA)
}
\arguments{
\item{api_number}{Integer related to the Fingrid Open Data API}

\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains wanted open data.
}
\description{
Main logic forming the API call. API key
can be provided as function parameter or environment
variable (in .Renviron as FINGRID_OPENDATA_API_KEY).
Function parameter has precedence in case both are provided.
For API spec see https://data.fingrid.fi/en/pages/api.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- get_data(api_number = 124,  # electricity demand for Finland
               start_time = start,
               end_time = end,
               user_key = key)
summary(df)
}
}
