% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick_charts.R
\name{compare_indicators}
\alias{compare_indicators}
\title{Plot compare indicators plot}
\usage{
compare_indicators(data, x, y, xlab = "", ylab = "", point_size = 4,
  highlight_area, area, add_R2 = FALSE)
}
\arguments{
\item{data}{data.frame object to plot using ggplot2 functions}

\item{x}{field containing x variable (unquoted)}

\item{y}{field containing y variable (unquoted)}

\item{xlab}{string; x-axis title}

\item{ylab}{string; y-axis title}

\item{point_size}{number; size of point}

\item{highlight_area}{character vector; list of areas for highlighting}

\item{area}{field containing areas - should contain contents of
highlight_area. Only required if highlight_area has a value (unquoted)}

\item{add_R2}{boolean; should R2 be displayed?}
}
\value{
a ggplot of compare indicators for 2 indicators
}
\description{
Plot compare indicators plot
}
\examples{
\donttest{
# This example is untested because of the time required to retrieve the data
library(fingertipsR)
library(dplyr)
library(tidyr)
df <- fingertips_data(c(90362, 90366)) \%>\%
        group_by(IndicatorID) \%>\%
        filter(Timeperiod == "2014 - 16" &
                       Sex == "Female") \%>\%
        ungroup() \%>\%
        select(IndicatorID, AreaName, Value) \%>\%
        mutate(IndicatorID = paste0("x", IndicatorID)) \%>\%
        spread(IndicatorID, Value)
p <- compare_indicators(df,
                        x = x90362,
                        y = x90366,
                        xlab = "Healthy life expectancy at birth",
                        ylab = "Life expectancy at birth",
                        highlight_area = c("England", "Dorset"),
                        area = AreaName)
p}
}
\seealso{
Other quick charts: \code{\link{box_plots}},
  \code{\link{compare_areas}}, \code{\link{map}},
  \code{\link{overview}}, \code{\link{population}},
  \code{\link{trends}}
}
