% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/second_filter_lotek.R
\name{second_filter_lotek}
\alias{second_filter_lotek}
\title{Four Hit Filter for Lotek Detections}
\usage{
second_filter_lotek(fish_file)
}
\arguments{
\item{fish_file}{a dataframe of detections retrieved from add_fish()}
}
\value{
A dataframe which has been filtered to remove false positives
}
\description{
This function takes a Lotek detection dataframe generated from the add_fish()
function and filters it a second time to remove any remaining multipath
detections, and then check the remaining detections by comparing the time
between detections, for a rolling window of 4 detections to ensure it is less
16.6x the stated pulse rate interval. It additionally checks that all
detections within the window occur within 20\% of the pulse rate interval of
the other detections and that the standard deviation of pulse rate intervals
is less than 0.025. Called by second_filter().
}
\examples{
# Apply the Lotek filter to a prefiltered dataset with fish and tag
# attributes
second_filter_lotek(filter_fish_detects)
}
