% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{CreateDirsIfNotThere}
\alias{CreateDirsIfNotThere}
\title{Create directories if they don't already exist.}
\usage{
CreateDirsIfNotThere(dir.names)
}
\arguments{
\item{dir.names}{The name of the directories, specified via relative or
absolute paths.}
}
\value{
Invisibly, a vector with a \code{TRUE} for each time a directory was
actually created and a \code{FALSE} otherwise.
}
\description{
Given the names of (potential) directories, create the ones that do not
already exist.
}
\examples{
setwd(tempdir())
CreateDirsIfNotThere(c("mydir", "yourdir"))
RemoveDirs(c("mydir", "yourdir"))
}
