% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humann2meco.R
\name{humann2meco}
\alias{humann2meco}
\title{Transform 'HUMAnN' metagenomic results to 'microtable' object.}
\usage{
humann2meco(
  abund_table,
  db = c("MetaCyc", "KEGG")[1],
  sample_data = NULL,
  match_table = NULL,
  ...
)
}
\arguments{
\item{abund_table}{'HUMAnN' output abundance table, see the example.}

\item{db}{default "MetaCyc"; either "MetaCyc" or "KEGG"; the pathway database used in the abund_table file generation.}

\item{sample_data}{default NULL; the sample metadata table, must be tab or comma seperated file, generally, a file with suffix "tsv" or "csv".}

\item{match_table}{default NULL; a two column table used to replace the sample names in 'HUMAnN abundance result; Remember just two columns with no column names;
The first column must be sample names used in abund_table, the second column is the new sample names, e.g. the rownames in sample_table. See the example files.}

\item{...}{parameter passed to microtable$new function of microeco package, such as auto_tidy parameter.}
}
\value{
microtable object.
}
\description{
Transform 'HUMAnN' metagenomic results to microtable object, reference: Franzosa et al. (2018) <doi:10.1038/s41592-018-0176-y>.
}
\examples{
\donttest{
library(file2meco)
library(microeco)
library(magrittr)
sample_file_path <- system.file("extdata", "example_metagenome_sample_info.tsv", 
  package="file2meco")
match_file_path <- system.file("extdata", "example_metagenome_match_table.tsv", package="file2meco")
# MetaCyc pathway examples
# use the raw data files stored inside the package for MetaCyc pathway database based analysis
abund_file_path <- system.file("extdata", "example_HUMAnN_MetaCyc_abund.tsv", package="file2meco")
# the default db is "MetaCyc"
humann2meco(abund_table = abund_file_path, db = "MetaCyc")
humann2meco(abund_table = abund_file_path, db = "MetaCyc", sample_data = sample_file_path, 
  match_table = match_file_path)
test <- humann2meco(abund_table = abund_file_path, db = "MetaCyc", sample_data = sample_file_path, 
  match_table = match_file_path)
test$tidy_dataset()
# rel = FALSE donot use relative abundance
test$cal_abund(select_cols = 1:3, rel = FALSE)
test$taxa_abund$Superclass1 \%<>\% .[!grepl("unclass", rownames(.)), ]
test1 <- trans_abund$new(test, taxrank = "Superclass1", ntaxa = 10)
test1$plot_bar(facet = "Group", ylab_title = "Abundance (RPK)")
# select both function and taxa
test$cal_abund(select_cols = c("Superclass1", "Phylum", "Genus"), rel = TRUE)
test1 <- trans_abund$new(test, taxrank = "Phylum", ntaxa = 10, delete_part_prefix = TRUE)
test1$plot_bar(facet = "Group")
test$taxa_abund$Phylum \%<>\% .[!grepl("unclass", rownames(.)), ]
test1 <- trans_abund$new(test, taxrank = "Phylum", ntaxa = 10, delete_part_prefix = TRUE)
test1$plot_bar(facet = "Group")
# functional biomarker
test$cal_abund(select_cols = 1:3, rel = TRUE)
test$taxa_abund$Superclass1 \%<>\% .[!grepl("unclass", rownames(.)), ]
test$taxa_abund$Superclass2 \%<>\% .[!grepl("unclass", rownames(.)), ]
test$taxa_abund$pathway \%<>\% .[!grepl("unclass", rownames(.)), ]
test1 <- trans_diff$new(test, method = "lefse", group = "Group")
test1$plot_diff_bar(use_number = 1:20)
# taxa biomarker
test$cal_abund(select_cols = 4:9, rel = TRUE)
test$taxa_abund$Phylum \%<>\% .[!grepl("unclass", rownames(.)), ]
test1 <- trans_diff$new(test, method = "lefse", group = "Group")
test1$plot_diff_bar(threshold = 2)
#############################################################
# KEGG pathway examples
abund_file_path <- system.file("extdata", "example_HUMAnN_KEGG_abund.tsv", package="file2meco")
humann2meco(abund_table = abund_file_path, db = "KEGG")
test <- humann2meco(abund_table = abund_file_path, db = "KEGG", 
  sample_data = sample_file_path, match_table = match_file_path)
test$tax_table \%<>\% subset(Level.1 != "unclassified")
test$tidy_dataset()
# rel = FALSE donot use relative abundance
test$cal_abund(select_cols = 1:3, rel = FALSE)
test1 <- trans_abund$new(test, taxrank = "Level.2", ntaxa = 10)
test1$plot_bar(facet = "Group", ylab_title = "Abundance (RPK)")
# select both function and taxa
test$cal_abund(select_cols = c("Level.1", "Phylum", "Genus"), rel = TRUE)
test1 <- trans_abund$new(test, taxrank = "Phylum", ntaxa = 10, delete_part_prefix = TRUE)
test1$plot_bar(facet = "Group")
# functional biomarker
test$cal_abund(select_cols = 1:3, rel = TRUE)
test1 <- trans_diff$new(test, method = "lefse", group = "Group")
test1$plot_diff_bar(threshold = 3)
# taxa biomarker
test$cal_abund(select_cols = 4:9, rel = TRUE)
test1 <- trans_diff$new(test, method = "lefse", group = "Group")
test1$plot_diff_bar(threshold = 2)
}
}
